/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import java.util.ArrayList;

public class VideoPlayerTopBar
extends RelativeLayout {
    private View mRootView;
    private TextView mTitleTextView;
    private TextView mNumberOfLikesTextView;
    private ImageView mLikeIndicationImageView;
    private VideoPlayerTopBarListener mVideoPlayerTopBarListener;
    private Handler mHandler;
    private ArrayList<View> mTopBarViewsArrayList;

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.getResources().getConfiguration().orientation == 1) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public VideoPlayerTopBar(Context context) {
        super(context);
        this.initView();
    }

    public VideoPlayerTopBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.initBackground();
    }

    private void initBackground() {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        View backgroundMainView = this.mRootView.findViewById(R.id.MainBackground);
        backgroundMainView.getLayoutParams().height = (int)((float)screenMaxSize * 0.061458334f);
    }

    public void setVideoPlayerTopBarListener(VideoPlayerTopBarListener videoPlayerTopBarListener) {
        this.mVideoPlayerTopBarListener = videoPlayerTopBarListener;
    }

    public void setTopBarTitle(String title) {
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setText((CharSequence)title);
        }
    }

    public void setNumberOfLikesTextView(String numberOfLikes) {
        if (this.mNumberOfLikesTextView != null) {
            this.mNumberOfLikesTextView.setText((CharSequence)numberOfLikes);
        }
    }

    public void setLikeIndicationStatus(boolean isLiked) {
        if (this.mLikeIndicationImageView != null) {
            this.mLikeIndicationImageView.setSelected(isLiked);
        }
    }

    public void animateEnter() {
        if (this.getResources().getConfiguration().orientation == 2) {
            AnimationsUtils.animateTopBarSlideIn((View)this);
        }
    }

    public void animateExit() {
        if (this.getResources().getConfiguration().orientation == 2) {
            AnimationsUtils.animateTopBarSlideOut((View)this);
        }
    }

    public void performClickIfNeeded(int x, int y) {
        if (this.mTopBarViewsArrayList != null && !this.mTopBarViewsArrayList.isEmpty()) {
            for (View nextView : this.mTopBarViewsArrayList) {
                int height;
                if (nextView == null || nextView.getVisibility() != 0) continue;
                int[] locationOnScreen = new int[2];
                nextView.getLocationOnScreen(locationOnScreen);
                int width = nextView.getWidth();
                Rect rect = new Rect(locationOnScreen[0], locationOnScreen[1], locationOnScreen[0] + width, locationOnScreen[1] + (height = nextView.getHeight()));
                if (!rect.contains(x, y)) continue;
                nextView.performClick();
                break;
            }
        }
    }

    private static int getTitleTextSizeByScreenLayout(Context context) {
        int size = 17;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 15;
                break;
            }
            case 2: {
                size = 18;
                break;
            }
            case 3: {
                size = 23;
                break;
            }
            case 4: {
                size = 27;
            }
        }
        return size;
    }

    public static interface VideoPlayerTopBarListener {
        public void onBackPressed();

        public void onLikeClicked();

        public void onInfoClicked();
    }
}

