/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;

public class PlayAndPauseButton
extends RelativeLayout {
    private ImageView mIconImageView;
    private Handler mHandler;
    private InterceptTouchEventListener mInterceptTouchEventListener;
    private PLAY_AND_PAUSE_STATUS mPlayerStatus;

    public PlayAndPauseButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.setBackgroundResource(R.drawable.youtube_refresh_video_icon);
        this.mHandler = new Handler();
        this.mIconImageView = new ImageView(this.getContext());
        this.mIconImageView.setImageResource(R.drawable.animateable_refresh_icon);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mIconImageView, (ViewGroup.LayoutParams)params);
    }

    public void setStatus(PLAY_AND_PAUSE_STATUS status) {
        this.mIconImageView.clearAnimation();
        this.mPlayerStatus = status;
        switch (this.mPlayerStatus) {
            case LOADING: {
                this.setBackgroundResource(R.drawable.youtube_refresh_video_icon);
                this.mIconImageView.setImageResource(R.drawable.animateable_refresh_icon);
            }
            case ERROR: {
                break;
            }
            case PLAYING: {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PlayAndPauseButton.this.setBackgroundResource(0);
                        PlayAndPauseButton.this.mIconImageView.setImageResource(R.drawable.youtube_pause_video_icon);
                    }
                }, 300L);
                break;
            }
            case PAUSING: {
                this.setBackgroundResource(0);
                this.mIconImageView.setImageResource(R.drawable.youtube_play_video_icon);
            }
        }
    }

    public void animateLoading() {
        if (this.mPlayerStatus == PLAY_AND_PAUSE_STATUS.LOADING) {
            AnimationsUtils.animateRotate((View)this.mIconImageView);
        }
    }

    public PLAY_AND_PAUSE_STATUS getPlayAndPauseStatus() {
        return this.mPlayerStatus;
    }

    public void animateEnter() {
        AnimationsUtils.animateFade((View)this, true, 1500L, null);
    }

    public void animateExit() {
        if (this.mPlayerStatus != PLAY_AND_PAUSE_STATUS.ERROR) {
            AnimationsUtils.animateFade((View)this, false, 1500L, null);
        }
    }

    public void setInterceptTouchEventListener(InterceptTouchEventListener interceptTouchEventListener) {
        this.mInterceptTouchEventListener = interceptTouchEventListener;
    }

    public static enum PLAY_AND_PAUSE_STATUS {
        PLAYING,
        PAUSING,
        ERROR,
        LOADING;

    }

    public static interface InterceptTouchEventListener {
        public void setIsCanInterceptTouchEvent(boolean var1);
    }
}

