/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.adapters;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.infra_structure.BaseContentItem;
import com.kidoz.sdk.api.players.video_player.logics.RELATED_CONTENT_CONTAINER_TYPE;
import com.kidoz.sdk.api.players.video_player.logics.RelatedContentListener;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.FontUtils;
import com.kidoz.sdk.api.players.video_player.util.ImageUtil;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.squareup.imagelib.Picasso;
import java.util.ArrayList;

public class RelatedContentAdapter
extends RecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private final String TAG = RelatedContentAdapter.class.getSimpleName();
    public static final float ITEM_RATIO_TABLET_LANDSCAPE = 0.65f;
    public static final float ITEM_RATIO_TABLET_PORTRAIT = 0.8f;
    public static final int ROWS_COUNT_TABLET_LANDSCAPE = 2;
    public static final int ROWS_COUNT_TABLET_PORTRAIT = 2;
    public static final float ITEM_RATIO_PHONE_LANDSCAPE = 0.8f;
    public static final float ITEM_RATIO_PHONE_PORTRAIT = 0.8f;
    public static final int ROWS_COUNT_PHONE_LANDSCAPE = 3;
    public static final int ROWS_COUNT_PHONE_PORTRAIT = 2;
    private Context mContext;
    private ArrayList<BaseContentItem> mContent;
    private int mLastPosition = -1;
    private LinearInterpolator mLinearInterpolator;
    private RelatedContentListener mRelatedContentListener;
    private ArrayList<BaseContentItem> mImpresseionsArrayList;
    private RELATED_CONTENT_CONTAINER_TYPE mContainerType;
    private int mContentTypeIconSize;

    private Animator[] getAnimators(View view) {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.5f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.5f, 1.0f});
        return new ObjectAnimator[]{scaleX, scaleY, alpha};
    }

    private void clearAnimation(View view) {
        ViewCompat.setAlpha((View)view, (float)1.0f);
        ViewCompat.setScaleY((View)view, (float)1.0f);
        ViewCompat.setScaleX((View)view, (float)1.0f);
        ViewCompat.setTranslationY((View)view, (float)0.0f);
        ViewCompat.setTranslationX((View)view, (float)0.0f);
        ViewCompat.setRotation((View)view, (float)0.0f);
        ViewCompat.setRotationY((View)view, (float)0.0f);
        ViewCompat.setRotationX((View)view, (float)0.0f);
        view.setPivotY((float)(view.getMeasuredHeight() / 2));
        ViewCompat.setPivotX((View)view, (float)(view.getMeasuredWidth() / 2));
        ViewCompat.animate((View)view).setInterpolator(null);
    }

    public RelatedContentAdapter(Context context, RELATED_CONTENT_CONTAINER_TYPE containerType) {
        this.mContainerType = containerType;
        this.mContext = context;
        this.mContent = new ArrayList();
        this.mImpresseionsArrayList = new ArrayList();
        this.mLinearInterpolator = new LinearInterpolator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(ArrayList<BaseContentItem> content) {
        RelatedContentAdapter relatedContentAdapter = this;
        synchronized (relatedContentAdapter) {
            if (content != null) {
                this.mImpresseionsArrayList.clear();
                if (this.mContent.isEmpty()) {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyItemRangeInserted(0, this.getItemCount());
                    this.notifyItemRangeChanged(0, this.getItemCount());
                } else {
                    this.mContent.clear();
                    this.mContent.addAll(content);
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    public int getItemCount() {
        int result = 0;
        if (this.mContent != null) {
            result = this.mContent.size();
        }
        return result;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int arg1) {
        View convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.related_content_item_layout, parent, false);
        ViewHolder viewHolder = new ViewHolder(convertView);
        viewHolder.mRootView.setOnClickListener((View.OnClickListener)this);
        viewHolder.mRootView.setTag((Object)viewHolder);
        return viewHolder;
    }

    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        BaseContentItem baseContentItem = this.mContent.get(position);
        if (baseContentItem != null) {
            this.handleImpresseion(baseContentItem, position, this.mContainerType);
            this.fixItemSize(viewHolder);
            this.loadThumbnailAndSetBackgroundAndTextColor(viewHolder, baseContentItem);
            this.loadContentTypeIcon(viewHolder, baseContentItem);
            this.setItemDescription(viewHolder, baseContentItem);
        }
        if (position > this.mLastPosition) {
            for (Animator anim : this.getAnimators((View)viewHolder.mRootView)) {
                anim.setInterpolator((TimeInterpolator)this.mLinearInterpolator);
                anim.setDuration(300L).start();
            }
            this.mLastPosition = position;
        } else {
            this.clearAnimation((View)viewHolder.mRootView);
        }
    }

    public void onClick(View view) {
        ViewHolder viewHolder = (ViewHolder)((Object)view.getTag());
        final int position = this.getItemPosition(viewHolder);
        if (position != -1 && this.mContent.size() > position) {
            BaseContentItem baseContentItem = this.mContent.get(position);
            AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (RelatedContentAdapter.this.mRelatedContentListener != null) {
                        RelatedContentAdapter.this.mRelatedContentListener.onRelatedContentItemClick(position);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    private void handleImpresseion(BaseContentItem baseContentItem, int position, RELATED_CONTENT_CONTAINER_TYPE mContainerType) {
        if (!this.mImpresseionsArrayList.contains(baseContentItem) && this.mRelatedContentListener != null) {
            int orientation = this.mContext.getResources().getConfiguration().orientation;
            switch (mContainerType) {
                case VIDEO_GRID: {
                    if (orientation != 1) break;
                    this.mRelatedContentListener.onFirstTimeItemVisible(position, mContainerType);
                    this.mImpresseionsArrayList.add(baseContentItem);
                    break;
                }
                case VIDEO_HORIZONTAL_SCROLL: {
                    if (orientation != 2) break;
                    this.mRelatedContentListener.onFirstTimeItemVisible(position, mContainerType);
                    this.mImpresseionsArrayList.add(baseContentItem);
                }
            }
        }
    }

    private int getItemPosition(ViewHolder viewHolder) {
        int result = viewHolder.getAdapterPosition();
        if (result == -1) {
            result = viewHolder.getPosition();
        }
        return result;
    }

    private void loadThumbnailAndSetBackgroundAndTextColor(ViewHolder viewHolder, BaseContentItem baseContentItem) {
        Picasso.with(this.mContext).load(baseContentItem.getThumbnailURL()).into(viewHolder.mThumbnailSimpleDraweeView);
        viewHolder.mDescriptionTextView.setTextColor(baseContentItem.getDescriptionColor());
        viewHolder.mRootView.setCardBackgroundColor(baseContentItem.getBackgroundColor());
    }

    private void loadContentTypeIcon(ViewHolder viewHolder, BaseContentItem baseContentItem) {
        viewHolder.mContentTypeSimpleDraweeView.setImageURI(ImageUtil.prepareCorrectUri(baseContentItem.getIconResourceID()));
    }

    private void setItemDescription(ViewHolder viewHolder, BaseContentItem baseContentItem) {
        if (viewHolder != null && baseContentItem != null) {
            viewHolder.mDescriptionTextView.setText((CharSequence)baseContentItem.getDescription());
        }
    }

    private void fixItemSize(ViewHolder viewHolder) {
        float itemRatio;
        int numberOfItemsInARow;
        viewHolder.mDescriptionTextView.setLines(2);
        viewHolder.mDescriptionTextView.setMaxLines(2);
        if (this.mContext.getResources().getConfiguration().orientation == 2) {
            if (ScreenUtils.getIsTablet(this.mContext)) {
                numberOfItemsInARow = 2;
                itemRatio = 0.65f;
            } else {
                viewHolder.mDescriptionTextView.setLines(1);
                viewHolder.mDescriptionTextView.setMaxLines(1);
                numberOfItemsInARow = 3;
                itemRatio = 0.8f;
            }
        } else if (ScreenUtils.getIsTablet(this.mContext)) {
            numberOfItemsInARow = 2;
            itemRatio = 0.8f;
        } else {
            numberOfItemsInARow = 2;
            itemRatio = 0.8f;
        }
        int screenWidth = Math.min(ScreenUtils.getScreenSize(this.mContext, true), ScreenUtils.getScreenSize(this.mContext, false));
        int itemWidth = screenWidth / numberOfItemsInARow;
        int itemHeight = (int)((float)itemWidth * itemRatio);
        RecyclerView.LayoutParams rootViewParams = (RecyclerView.LayoutParams)viewHolder.mRootView.getLayoutParams();
        rootViewParams.width = itemWidth;
        rootViewParams.height = itemHeight;
        viewHolder.mRootView.setLayoutParams((ViewGroup.LayoutParams)rootViewParams);
        this.mContentTypeIconSize = (int)((double)itemWidth * 0.2);
        RelativeLayout.LayoutParams contentTypeIconParams = (RelativeLayout.LayoutParams)viewHolder.mContentTypeSimpleDraweeView.getLayoutParams();
        contentTypeIconParams.width = this.mContentTypeIconSize;
        contentTypeIconParams.height = this.mContentTypeIconSize;
        contentTypeIconParams.rightMargin = (int)((double)this.mContentTypeIconSize * 0.25);
        contentTypeIconParams.bottomMargin = (int)((double)this.mContentTypeIconSize * 0.6) * -1;
        viewHolder.mContentTypeSimpleDraweeView.setLayoutParams((ViewGroup.LayoutParams)contentTypeIconParams);
    }

    public void setRelatedContentListener(RelatedContentListener relatedContentListener) {
        this.mRelatedContentListener = relatedContentListener;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private CardView mRootView;
        private ImageView mThumbnailSimpleDraweeView;
        private ImageView mContentTypeSimpleDraweeView;
        private TextView mDescriptionTextView;

        public ViewHolder(View rootView) {
            super(rootView);
            this.mRootView = (CardView)rootView;
            this.mThumbnailSimpleDraweeView = (ImageView)this.mRootView.findViewById(R.id.ThumbnailSimpleDraweeView);
            this.mContentTypeSimpleDraweeView = (ImageView)this.mRootView.findViewById(R.id.ContentTypeIconSimpleDraweeView);
            this.mDescriptionTextView = (TextView)this.mRootView.findViewById(R.id.RelatedContentDescriptionTextView);
            this.mDescriptionTextView.setTypeface(FontUtils.getFont(this.mDescriptionTextView.getContext(), FontUtils.FONT_TYPE.DOSIS_BOLD.getValue()));
        }
    }
}

