/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.picasso_related;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import com.squareup.imagelib.Transformation;

public class RoundedTransformation
implements Transformation {
    private final int radius;
    private final int margin;

    public RoundedTransformation(int radius, int margin) {
        this.radius = radius;
        this.margin = margin;
    }

    @Override
    public Bitmap transform(Bitmap source) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Bitmap output = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawRoundRect(new RectF((float)this.margin, (float)this.margin, (float)(source.getWidth() - this.margin), (float)(source.getHeight() - this.margin)), (float)this.radius, (float)this.radius, paint);
        if (source != output) {
            source.recycle();
        }
        return output;
    }

    @Override
    public String key() {
        return "rounded";
    }
}

