/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.FontManagerUtil;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;

public class KidozTopBar
extends LinearLayout {
    public static final float BACKGROUND_RATIO = 0.061458334f;
    public static final float BACKGROUND_DEKO_RATIO = 0.26222223f;
    public static final float CLOUDS_RATIO_AGAINST_TOP_BAR = 0.91525424f;
    public static final float CLOUDS_RATIO = 0.13899614f;
    public static final float TOP_ICONS_RELATIVE_SIZE = 0.5f;
    private RelativeLayout mRootView;
    private TextView mTitleTextView;
    private KidozTopBarListener mKidozTopBarListener;
    private TopBarCloseMode mTopBarCloseMode = TopBarCloseMode.BACK_BUTTON;
    private ImageView mLockIconImageView;
    private ImageView mExitIconImageView;
    private boolean mIsParentalLockVisible;
    private boolean mIsClicksBlocked;

    public KidozTopBar(Context context, TopBarCloseMode topBarCloseMode) {
        super(context);
        this.mTopBarCloseMode = topBarCloseMode;
        this.initView();
    }

    public KidozTopBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.initRootView();
        this.initBackground();
        this.initTitle();
        this.initExitButton();
        this.initLockButton();
    }

    private void initRootView() {
        this.mRootView = (RelativeLayout)KidozTopBar.inflate((Context)this.getContext(), (int)R.layout.video_player_top_bar, null);
        this.mRootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return KidozTopBar.this.mIsClicksBlocked;
            }
        });
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.mRootView, params);
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    KidozTopBar.this.mRootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    KidozTopBar.this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                KidozTopBar.this.mLockIconImageView.setVisibility(4);
                if (KidozTopBar.this.mIsParentalLockVisible) {
                    KidozTopBar.this.mLockIconImageView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GenAnimator.playDropAnimation((View)KidozTopBar.this.mLockIconImageView, new Animator.AnimatorListener(){

                                public void onAnimationStart(Animator animation) {
                                    KidozTopBar.this.mLockIconImageView.setVisibility(0);
                                }

                                public void onAnimationEnd(Animator animation) {
                                }

                                public void onAnimationCancel(Animator animation) {
                                }

                                public void onAnimationRepeat(Animator animation) {
                                }
                            });
                        }
                    }, 370L);
                }
                KidozTopBar.this.mExitIconImageView.setVisibility(4);
                KidozTopBar.this.mExitIconImageView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GenAnimator.playDropAnimation((View)KidozTopBar.this.mExitIconImageView, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                                KidozTopBar.this.mExitIconImageView.setVisibility(0);
                            }

                            public void onAnimationEnd(Animator animation) {
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }, 290L);
            }
        });
    }

    private void initBackground() {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(this.getContext(), true), ScreenUtils.getScreenSize(this.getContext(), false));
        View backgroundMainView = this.mRootView.findViewById(R.id.MainBackground);
        backgroundMainView.getLayoutParams().height = (int)((float)screenMaxSize * 0.061458334f);
    }

    private void initTitle() {
        this.mTitleTextView = (TextView)this.mRootView.findViewById(R.id.TopBarTitleTextView);
        this.mTitleTextView.setTextColor(this.getResources().getColor(R.color.TopBarTitle));
        this.mTitleTextView.setShadowLayer(2.0f, 1.0f, 1.0f, this.getResources().getColor(R.color.TopBarTitleShadow));
        this.mTitleTextView.setTextSize(2, (float)KidozTopBar.getTitleTextSizeByScreenLayout(this.getContext()));
        this.mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitleTextView.setTypeface(FontManagerUtil.getFont(this.getContext(), FontManagerUtil.FONT_TYPE.BARIO_BOLD.getValue()));
    }

    private void initLockButton() {
        boolean isLockActive;
        this.mIsParentalLockVisible = true;
        this.mLockIconImageView = (ImageView)this.mRootView.findViewById(R.id.LockCloudButton);
        boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
        if (isLockActive) {
            this.mLockIconImageView.setImageResource(R.drawable.lock_cloud);
        } else {
            this.mLockIconImageView.setImageResource(R.drawable.lock_cloud_open);
        }
        this.mLockIconImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    GenAnimator.playStandUpAnimation(view, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            int lockStatus = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") == null ? 0 : 1;
                            EventManager.getInstance().LogEventWithIntField(KidozTopBar.this.getContext(), EventManager.LOG_NORMAL_LEVEL, "Parental Lock", "Click", "Lock Button", lockStatus);
                            ParentalLockDialog parentalLockDialog = new ParentalLockDialog(KidozTopBar.this.getContext(), false);
                            parentalLockDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                                public void onDismiss(DialogInterface dialog) {
                                    KidozTopBar.this.mIsClicksBlocked = false;
                                }
                            });
                            parentalLockDialog.setParentLockDialogListener(new ParentalLockDialog.ParentLockDialogListener(){

                                @Override
                                public void onPasswordEntered(boolean isPasswordCorrect) {
                                    boolean isLockActive;
                                    boolean bl = isLockActive = SharedPreferencesUtils.loadSharedPreferencesData(KidozTopBar.this.getContext(), "PARENTAL_LOCK_ACTIVE_KEY") != null;
                                    if (isLockActive) {
                                        KidozTopBar.this.mLockIconImageView.setImageResource(R.drawable.lock_cloud);
                                    } else {
                                        KidozTopBar.this.mLockIconImageView.setImageResource(R.drawable.lock_cloud_open);
                                    }
                                }
                            });
                            parentalLockDialog.show();
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    GenAnimator.playStandUpAnimation(view, null);
                }
            }
        });
    }

    private void initExitButton() {
        this.mExitIconImageView = (ImageView)this.mRootView.findViewById(R.id.ExitCloudButton);
        this.mExitIconImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!KidozTopBar.this.mIsClicksBlocked) {
                    KidozTopBar.this.mIsClicksBlocked = true;
                    GenAnimator.playStandUpAnimation(v, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            EventManager.getInstance().LogEvent(KidozTopBar.this.getContext(), EventManager.LOG_NORMAL_LEVEL, null, "SDK", "Click", "Back Button");
                            if (KidozTopBar.this.mKidozTopBarListener != null) {
                                KidozTopBar.this.mKidozTopBarListener.onExitClicked(null);
                            }
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                } else {
                    GenAnimator.playStandUpAnimation(v, null);
                }
            }
        });
        switch (this.mTopBarCloseMode) {
            case BACK_BUTTON: {
                this.mExitIconImageView.setImageResource(R.drawable.back_cloud);
                break;
            }
            case CLOSE_BUTTON: {
                this.mExitIconImageView.setImageResource(R.drawable.exit_cloud);
            }
        }
    }

    public void setKidozTopBarListener(KidozTopBarListener kidozTopBarListener) {
        this.mKidozTopBarListener = kidozTopBarListener;
    }

    public void setTitle(String title) {
        if (this.mTitleTextView != null) {
            SpannableString spannableString = new SpannableString((CharSequence)title);
            spannableString.setSpan((Object)new StyleSpan(1), 0, spannableString.length(), 0);
            this.mTitleTextView.setText((CharSequence)spannableString);
            this.invalidate();
        }
    }

    public void setTopBarBackgroundColor(int color2) {
    }

    private static int getTitleTextSizeByScreenLayout(Context context) {
        int size = 20;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 18;
                break;
            }
            case 2: {
                size = 21;
                break;
            }
            case 3: {
                size = 26;
                break;
            }
            case 4: {
                size = 30;
            }
        }
        return size;
    }

    public void showParentalLockIcon(boolean show) {
        this.mIsParentalLockVisible = show;
        if (this.mIsParentalLockVisible) {
            this.mLockIconImageView.setVisibility(0);
        } else {
            this.mLockIconImageView.setVisibility(4);
        }
    }

    public static interface KidozTopBarListener {
        public void onExitClicked(View var1);
    }

    public static enum TopBarCloseMode {
        CLOSE_BUTTON,
        BACK_BUTTON;

    }
}

