/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;

public class GenAnimator {
    public static AnimatorSet clickItemAnimation(View view, int duration, final ViewAnimationListener listener) {
        AnimatorSet cilAnim = new AnimatorSet();
        AnimatorSet clickSet = new AnimatorSet();
        clickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 0.8f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 0.8f})});
        AnimatorSet unClickSet = new AnimatorSet();
        unClickSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.8f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.8f, 1.0f})});
        cilAnim.playSequentially(new Animator[]{clickSet, unClickSet});
        cilAnim.setDuration((long)duration);
        cilAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        cilAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        cilAnim.start();
        return cilAnim;
    }

    public static AnimatorSet recycleItemAnimation(View view, final ViewAnimationListener listener) {
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.52f, 1.0f});
        anim1.setDuration(250L);
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.52f, 1.0f});
        anim2.setDuration(250L);
        ObjectAnimator anim3 = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.2f, 1.0f});
        anim3.setDuration(250L);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{anim1, anim2, anim3});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.start();
        return set;
    }

    public static AnimatorSet playSlideUpAnimation(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener) {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{slideOffset, 0.0f}));
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideDownAnimation(View view, int slideOffset, int duration, TimeInterpolator timeInterpolator, Animator.AnimatorListener animatorListener) {
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, slideOffset}));
        set.setDuration((long)duration);
        if (timeInterpolator != null) {
            set.setInterpolator(timeInterpolator);
        }
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-distance, 0.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{distance, 0.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideOutLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, -view.getWidth()})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playSlideOutRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        int distance = view.getWidth() - view.getLeft();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, distance})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playBounceInRightAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-view.getWidth(), 30.0f, -10.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f})});
        set.setDuration((long)duration);
        set.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playBounceInLeftAnimation(View view, Animator.AnimatorListener animatorListener, int duration) {
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{view.getWidth(), -30.0f, 10.0f, 0.0f}), ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 1.0f})});
        set.setDuration((long)duration);
        if (animatorListener != null) {
            set.addListener(animatorListener);
        }
        set.start();
        return set;
    }

    public static AnimatorSet playStandUpAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        float x = (target.getWidth() - target.getPaddingLeft() - target.getPaddingRight()) / 2 + target.getPaddingLeft();
        float y = target.getPaddingBottom();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{x}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{y, y}), ObjectAnimator.ofFloat((Object)target, (String)"rotationX", (float[])new float[]{-15.0f, -30.0f, -15.0f, 0.0f, 15.0f, 0.0f, -15.0f, 0.0f, 10.0f, 0.0f, -10.0f, 0.0f, 5.0f, 0.0f, -5.0f, 0.0f})});
        result.setDuration(750L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playDropAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new BounceInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-target.getHeight(), 0.0f})});
        result.setDuration(800L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playOnBoardingCloudDropAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new LinearInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-target.getHeight(), 0.0f})});
        result.setDuration(800L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutAnimation(View target, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{0.0f, -target.getHeight()})});
        result.setDuration(450L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        result.setDuration(300L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopInFromRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        result.setDuration(300L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightBottom(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = target.getWidth() - pivot[0];
        int pivotY = target.getHeight() - pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        result.setDuration(400L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static AnimatorSet playPopOutToRightTop(View target, int[] pivot, Animator.AnimatorListener animatorListener) {
        target.clearAnimation();
        int pivotX = -target.getLeft() + pivot[0];
        int pivotY = -target.getTop() + pivot[1];
        AnimatorSet result = new AnimatorSet();
        result.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        result.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)target, (String)"pivotX", (float[])new float[]{pivotX, pivotX}), ObjectAnimator.ofFloat((Object)target, (String)"pivotY", (float[])new float[]{pivotY, pivotY}), ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        result.setDuration(400L);
        if (animatorListener != null) {
            result.addListener(animatorListener);
        }
        result.start();
        return result;
    }

    public static interface ViewAnimationListener {
        public void onAnimationEnd();

        public void onAnimationStart();
    }
}

