/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.analytics.EventsBulk;
import com.kidoz.sdk.api.analytics.KidozEventManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResultData;

public class SyncEventService
extends IntentService {
    public static final String TAG = SyncEventService.class.getSimpleName();
    private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
    private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 900000;
    private Intent mIntent;
    private boolean mSyncRunning = false;
    private boolean mContinueSyncProcces;
    private int munOfRetriesInCaseFailedCount = 1;
    private long mServiceSyncStartTime;

    public SyncEventService() {
        super("LogIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
        if (intent != null && intent.hasExtra("STOP_SERVICE_EXTRA")) {
            this.mSyncRunning = false;
            this.mContinueSyncProcces = false;
        }
        if (!this.mSyncRunning) {
            SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            SDKLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V3.0 ----------------------");
            SDKLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            this.mSyncRunning = true;
            this.mContinueSyncProcces = true;
            this.mServiceSyncStartTime = System.currentTimeMillis();
            while (KidozEventManager.getIsCanSendLog((Context)this) && this.isAllowedToRunTimeFrame() && this.mContinueSyncProcces) {
                SDKLogger.printDebbugLog(TAG, ">>>> SyncEventService : sending logs");
                EventsBulk bulk = KidozEventManager.getNextBulk((Context)this);
                if (bulk != null) {
                    String json = bulk.toString();
                    if (json != null) {
                        ResultData<Boolean> resultCallback = KidozSDK.getApiManager((Context)this).sendKidozEventsToServerNotAsync(json);
                        if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful()) {
                            KidozEventManager.removeBulkFromDB((Context)this, bulk);
                            this.munOfRetriesInCaseFailedCount = 1;
                            continue;
                        }
                        if (this.munOfRetriesInCaseFailedCount <= 0) break;
                        SDKLogger.printInfoLog(TAG, "Log Events Sync Info : Server responce failed ! Trying again...");
                        --this.munOfRetriesInCaseFailedCount;
                        continue;
                    }
                    SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
                    break;
                }
                SDKLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                break;
            }
        }
        this.mSyncRunning = false;
    }

    public boolean isAllowedToRunTimeFrame() {
        return System.currentTimeMillis() - this.mServiceSyncStartTime < 900000L;
    }

    public void onDestroy() {
        this.mContinueSyncProcces = false;
        super.onDestroy();
    }
}

