/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.kidoz.sdk.api.analytics.EventLogDatabaseManager;
import com.kidoz.sdk.api.analytics.EventsBulk;
import com.kidoz.sdk.api.analytics.GoogleAnalyticsTracker;
import com.kidoz.sdk.api.analytics.KidozEvent;
import com.kidoz.sdk.api.analytics.LogParameters;
import com.kidoz.sdk.api.analytics.SyncEventService;
import com.kidoz.sdk.api.analytics.SyncReciever;
import com.kidoz.sdk.api.analytics.TimedEventParams;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import java.util.zip.CRC32;
import org.json.JSONObject;

public class KidozEventManager {
    private static final String TAG = KidozEventManager.class.getSimpleName();
    public static final String SYNC_ALARM_INTENT = "kidoz.sync.alarm.event.action";
    public static final String STOP_SERVICE_EXTRA = "STOP_SERVICE_EXTRA";
    public static final int SYNC_ALARM_INTENT_REQUEST_CODE = 1982;
    private static final int SYNC_ALARM_INTERVAL_IN_MILLISECONDS = 300000;
    private static final int NIGHT_TIME_HOUR_VALUE_START = 21;
    private static final int NIGHT_TIME_HOUR_VALUE_END = 8;
    private static final int DAY_TIME_AMOUNT = 10;
    private static final int NIGHT_TIME_AMOUNT_EXTRA = 50;
    private static final int THREE_G_CONNECTON_TYPE_AMOUNT = 10;
    private static final int WIFI_CONNECTON_TYPE_AMOUNT_EXTRA = 20;
    private static final int SCREEN_STATE_ON_AMOUNT = 10;
    private static final int SCREEN_STATE_OFF_AMOUNT_EXTRA = 20;
    private static final String OS_TYPE = "Android";
    private static EventLogDatabaseManager sDatabaseManager;
    private static Utils.StaticHandler sStaticHandler;
    private static ArrayList<TimedEventParams> sTimedEventsArrayList;
    private static ArrayList<HitBuilders.EventBuilder> sTimedEventBuilderArrayList;
    private static boolean isDisableEventLogging;

    public static void setDisableLoggingEvents(boolean disable) {
        isDisableEventLogging = disable;
    }

    private KidozEventManager() {
    }

    public static void initKidozEventManager(Context context) {
        if (sTimedEventsArrayList == null) {
            sTimedEventsArrayList = new ArrayList();
        }
        if (sTimedEventBuilderArrayList == null) {
            sTimedEventBuilderArrayList = new ArrayList();
        }
        if (sDatabaseManager == null) {
            sDatabaseManager = new EventLogDatabaseManager(context);
        }
        if (sStaticHandler == null) {
            sStaticHandler = new Utils.StaticHandler();
        }
    }

    public static void setSyncAlarm(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, SyncReciever.class);
        intent.setAction(SYNC_ALARM_INTENT);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1982, (Intent)intent, (int)0x8000000);
        Random random = new Random();
        long currentTimeInMilliseconds = Calendar.getInstance().getTimeInMillis();
        long triggerAtMillis = currentTimeInMilliseconds + (long)random.nextInt(300000) + 300000L;
        alarmManager.set(0, triggerAtMillis, pendingIntent);
    }

    public static void cancelSyncAlarm(Context context) {
        Intent intent = new Intent(context, SyncReciever.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1982, (Intent)intent, (int)0x20000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (intent != null) {
            alarmManager.cancel(pendingIntent);
        }
    }

    public static void logTimedEventView(Context context, KidozEvent kidozEvent, HitBuilders.EventBuilder eventBuilder) {
        KidozEventManager.initKidozEventManager(context);
        String callingScreen = KidozEventManager.endTimedEventAndGetLastScreenLabel(context);
        if (callingScreen != null) {
            kidozEvent.addParameterToJsonObject("CallingScreen", callingScreen);
        }
        TimedEventParams timedEventParams = new TimedEventParams();
        timedEventParams.setKidozEvent(kidozEvent);
        timedEventParams.setEventStartTimeInMilliseconds(System.currentTimeMillis());
        sTimedEventsArrayList.add(timedEventParams);
    }

    public static String endTimedEventAndGetLastScreenLabel(Context context) {
        String result = null;
        String duration = null;
        if (sTimedEventsArrayList != null && !sTimedEventsArrayList.isEmpty()) {
            TimedEventParams timedEventParams = sTimedEventsArrayList.get(sTimedEventsArrayList.size() - 1);
            duration = timedEventParams.getDuration();
            timedEventParams.calculateAndAddEventDuration();
            KidozEventManager.logEvent(context, timedEventParams.getKidozEvent());
            sTimedEventsArrayList.remove(sTimedEventsArrayList.size() - 1);
            try {
                KidozEvent kidozEvent = timedEventParams.getKidozEvent();
                result = kidozEvent.getJSONObject().getString("Action");
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to get last screen value: " + ex.getMessage());
            }
        }
        if (sTimedEventBuilderArrayList != null && !sTimedEventBuilderArrayList.isEmpty()) {
            HitBuilders.EventBuilder eventBuilder = sTimedEventBuilderArrayList.get(sTimedEventBuilderArrayList.size() - 1);
            if (eventBuilder != null) {
                eventBuilder = (HitBuilders.EventBuilder)eventBuilder.setCustomDimension(10, duration);
                Tracker tracker = GoogleAnalyticsTracker.getGoogleAnalyticsTracker(context).getTracker();
                if (tracker != null) {
                    tracker.send(eventBuilder.build());
                }
            }
            sTimedEventBuilderArrayList.remove(sTimedEventBuilderArrayList.size() - 1);
        }
        return result;
    }

    public static void logEvent(Context context, final KidozEvent kidozEvent) {
        KidozEventManager.initKidozEventManager(context);
        if (!isDisableEventLogging) {
            sStaticHandler.post(new Runnable(){

                @Override
                public void run() {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SDKLogger.printInfoLog(TAG, "*** KidozEventManager ***");
                            SDKLogger.printInfoLog(TAG, ">>Insert New Log:");
                            kidozEvent.printData();
                            sDatabaseManager.getKidozEventsTable().inserLogEventToDB(kidozEvent);
                        }
                    }).start();
                }
            });
        }
    }

    private static JSONObject getDeviceParamsJsonObject(Context context) {
        JSONObject result = new JSONObject();
        try {
            String deviceID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            CRC32 crc = new CRC32();
            crc.update(deviceID.getBytes());
            result.put("DeviceHash", (Object)String.valueOf(crc.getValue()));
            result.put("UserRefferal", (Object)Utils.getDeviceReferral(context));
            result.put("PackageID", (Object)context.getPackageName());
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            result.put("AppVersion", (Object)String.valueOf(pInfo.versionName));
            result.put("DeviceType", (Object)String.valueOf(Build.DEVICE));
            result.put("DeviceBrand", (Object)String.valueOf(Build.MANUFACTURER));
            result.put("DeviceModel", (Object)String.valueOf(Build.MODEL));
            result.put("ScreenType", (Object)String.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
            result.put("ScreenSize", (Object)String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            result.put("DpiFactor", (Object)String.valueOf(metrics.densityDpi));
            result.put("ScreenW", (Object)String.valueOf(Utils.getScreenSize(context, true)));
            result.put("ScreenH", (Object)String.valueOf(Utils.getScreenSize(context, false)));
            result.put("OsType", (Object)String.valueOf(OS_TYPE));
            result.put("OsVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
            result.put("ConnectionType", (Object)LogParameters.convertConnectionTypeToString(BaseConnectionClient.getConnectionType(context)));
            result.put("DeviceLang", (Object)String.valueOf(Locale.getDefault().getLanguage()));
            result.put("TimeZone", (Object)LogParameters.getCurrentTimezoneOffset());
            result.put("Country", (Object)String.valueOf(Locale.getDefault().getCountry()));
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to create device params: " + ex.getMessage());
        }
        return result;
    }

    public static boolean getIsCanSendLog(Context context) {
        KidozEventManager.initKidozEventManager(context);
        boolean result = false;
        if (BaseConnectionClient.isNetworkAvailable(context) && !sDatabaseManager.getKidozEventsTable().isDBempty()) {
            result = true;
        }
        return result;
    }

    public static void startSync(Context context) {
        Intent intent = new Intent(context, SyncEventService.class);
        context.startService(intent);
    }

    public static Intent getSyncSericeIntent(Context context) {
        return new Intent(context, SyncEventService.class);
    }

    public static void stopSync(Context context) {
        Intent intent = new Intent(context, SyncEventService.class);
        intent.putExtra(STOP_SERVICE_EXTRA, true);
        context.stopService(intent);
    }

    public static EventsBulk getNextBulk(Context context) {
        KidozEventManager.initKidozEventManager(context);
        EventsBulk result = new EventsBulk();
        result.setDeviceParamsJSONObject(KidozEventManager.getDeviceParamsJsonObject(context));
        result.setKidozEventArrayList(sDatabaseManager.getKidozEventsTable().getKidozEvents(KidozEventManager.calculateBulkSize(context)));
        return result;
    }

    public static void removeBulkFromDB(Context context, EventsBulk eventsBulk) {
        KidozEventManager.initKidozEventManager(context);
        sDatabaseManager.getKidozEventsTable().removeLogEventsFromDB(eventsBulk.getKidozEventArrayList());
    }

    private static int calculateBulkSize(Context context) {
        int result = 30;
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        if (currentHour >= 21 || currentHour <= 8) {
            result += 50;
        }
        if (BaseConnectionClient.getConnectionType(context) == 1) {
            result += 20;
        }
        if (ScreenUtils.getIsScreenOff(context)) {
            result += 20;
        }
        return result;
    }

    public static void resetEvents() {
        if (sTimedEventsArrayList != null) {
            sTimedEventsArrayList.clear();
            sTimedEventsArrayList = null;
            sTimedEventBuilderArrayList.clear();
            sTimedEventBuilderArrayList = null;
        }
    }

    static {
        isDisableEventLogging = false;
    }
}

