/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

class KidozEvent {
    private final String TAG = KidozEvent.class.getName();
    private SimpleDateFormat mSimpleDateFormat;
    private JSONObject mJsonObject = new JSONObject();
    private String mRowID;

    public KidozEvent() {
        this.mSimpleDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.getDefault());
        this.mSimpleDateFormat.setTimeZone(TimeZone.getDefault());
        String logTimeUTC = String.valueOf(System.currentTimeMillis());
        String logTimeLocal = this.mSimpleDateFormat.format(new Date(System.currentTimeMillis()));
        try {
            this.mJsonObject.put("LogTimeUTC", (Object)logTimeUTC);
            this.mJsonObject.put("LogTimeLocal", (Object)logTimeLocal);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when tryin to add parameters to JsonObject: " + ex.getMessage());
        }
    }

    public void addParameterToJsonObject(String key, String value) {
        try {
            if (key != null && value != null) {
                this.mJsonObject.put(key, (Object)value);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(this.TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
        }
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.mJsonObject = jsonObject;
    }

    public JSONObject getJSONObject() {
        return this.mJsonObject;
    }

    public void setRowID(String rowID) {
        this.mRowID = rowID;
    }

    public String getRowID() {
        return this.mRowID;
    }

    public void printData() {
        SDKLogger.printInfoLog(this.TAG, "*** KidozEvent ***");
        SDKLogger.printInfoLog(this.TAG, "Row ID = " + this.mRowID);
        SDKLogger.printInfoLog(this.TAG, "JsonObject= " + this.mJsonObject.toString());
    }
}

