/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import com.kidoz.sdk.api.analytics.KidozEvent;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventsBulk {
    private final String TAG = EventsBulk.class.getSimpleName();
    public static final int SUCCESS = 1000;
    private final String KEY_DEVICE_PARAMS = "DeviceParams";
    private final String KEY_EVENT_PARAMS = "EventParams";
    private final String KEY_ENTRIES = "Entries";
    private JSONObject mDeviceParamsJSONObject;
    private ArrayList<KidozEvent> mKidozEventArrayList;

    public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject) {
        this.mDeviceParamsJSONObject = deviceParamsJSONObject;
    }

    public JSONObject getDeviceParamsJSONObject() {
        return this.mDeviceParamsJSONObject;
    }

    public void setKidozEventArrayList(ArrayList<KidozEvent> kidozEventArrayList) {
        this.mKidozEventArrayList = kidozEventArrayList;
    }

    public ArrayList<KidozEvent> getKidozEventArrayList() {
        return this.mKidozEventArrayList;
    }

    private String convertToJson() {
        String result = null;
        if (this.mDeviceParamsJSONObject != null && this.mKidozEventArrayList != null && this.mKidozEventArrayList.size() > 0) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("DeviceParams", (Object)this.mDeviceParamsJSONObject);
                JSONArray jSONArray = new JSONArray();
                for (KidozEvent nextKidozEvent : this.mKidozEventArrayList) {
                    JSONObject nextJsonObject = new JSONObject();
                    nextJsonObject.put("EventParams", (Object)nextKidozEvent.getJSONObject());
                    jSONArray.put((Object)nextJsonObject);
                }
                jSONObject.put("Entries", (Object)jSONArray);
                result = jSONObject.toString();
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return this.convertToJson();
    }

    public static ResultData<Boolean> parseResultSuccsesStatus(String data) {
        ResultData<Boolean> result = new ResultData<Boolean>();
        if (data != null) {
            ResponseStatus responseStatus = EventsBulk.parseResposneStatus(data);
            result.setResponseStatus(responseStatus);
            if (result.getResponseStatus().getErrorCode() != null && result.getResponseStatus().getErrorCode().equals(String.valueOf(1000))) {
                result.setData(true);
            } else {
                result.setData(false);
            }
        }
        return result;
    }

    protected static ResponseStatus parseResposneStatus(String data) {
        ResponseStatus responseStatus = new ResponseStatus();
        if (data != null) {
            try {
                JSONObject object;
                JSONArray jsonArray = new JSONArray(data);
                if (jsonArray != null && jsonArray.length() > 0 && (object = jsonArray.getJSONObject(0)) != null) {
                    if (!object.isNull("success")) {
                        responseStatus.setIsSuccessful(object.getBoolean("success"));
                    }
                    if (object.has("messageCode") && !object.isNull("messageCode")) {
                        responseStatus.setErrorCode(object.getString("messageCode"));
                    } else if (object.has("errorMessage") && !object.isNull("errorMessage")) {
                        responseStatus.setErrorCode(object.getString("errorMessage"));
                    }
                }
            }
            catch (JSONException ex) {
                SDKLogger.printErrorLog("Error parsing response status: " + ex.getMessage());
                return new ResponseStatus();
            }
        }
        return responseStatus;
    }
}

