/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.analytics;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.kidoz.sdk.api.analytics.KidozEventsTable;

class EventLogDatabaseManager
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "KIDOZ_LOG_EVENT_DATABASE_V3";
    private KidozEventsTable mKidozEventsTable;
    private static final int DATABASE_VERSION = 1;
    private int mOpenCounter;
    private SQLiteDatabase mDatabase;

    public EventLogDatabaseManager(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.initDatabase();
    }

    private void initDatabase() {
        this.mKidozEventsTable = new KidozEventsTable(this);
    }

    public void onCreate(SQLiteDatabase db) {
        KidozEventsTable.onCreate(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        KidozEventsTable.onUpgrade(db, oldVersion, newVersion);
    }

    public KidozEventsTable getKidozEventsTable() {
        return this.mKidozEventsTable;
    }

    public synchronized SQLiteDatabase openDatabase() {
        ++this.mOpenCounter;
        if (this.mOpenCounter == 1) {
            this.mDatabase = this.getWritableDatabase();
        }
        return this.mDatabase;
    }

    public synchronized void closeDatabase() {
        --this.mOpenCounter;
        if (this.mOpenCounter == 0) {
            this.mDatabase.close();
        }
    }
}

