/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.InterstitialView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.AnimatableGifImageView;
import com.kidoz.sdk.api.general.utils.Utils;

public class KidozButtonView
extends RelativeLayout {
    private static final String TAG = KidozButtonView.class.getSimpleName();
    private static final float BUTTON_SIZE_AS_SCREEN_PORTION = 0.27f;
    private AnimatableGifImageView mAnimatableGifImageView;
    private InterstitialView mInterstitialView;
    private View mRootView;

    public KidozButtonView(Context context) {
        super(context);
        this.intiView();
    }

    public KidozButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.intiView();
    }

    public KidozButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.intiView();
    }

    private void intiView() {
        this.mRootView = this;
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.27f);
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.more_btn_empty);
        int height = drawable2.getMinimumHeight();
        int width = drawable2.getMinimumWidth();
        float ratio = (float)height / (float)width;
        this.mAnimatableGifImageView = new AnimatableGifImageView(this.getContext());
        RelativeLayout.LayoutParams animatableImageParams = new RelativeLayout.LayoutParams(size, (int)((float)size * ratio));
        this.addView((View)this.mAnimatableGifImageView, (ViewGroup.LayoutParams)animatableImageParams);
        this.mAnimatableGifImageView.setBackgroundResource(R.drawable.more_btn_logo);
        if (!this.isInEditMode()) {
            this.mAnimatableGifImageView.setAnimatedGif(Utils.prepareCorrectUri("https://kidoz-cdn.s3.amazonaws.com/sdk/btn_animation.gif"), new AnimatableGifImageView.IOnAnimatedGifReadyListener(){

                @Override
                public void onGifReady() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        KidozButtonView.this.mAnimatableGifImageView.setBackground(null);
                    } else {
                        KidozButtonView.this.mAnimatableGifImageView.setBackgroundDrawable(null);
                    }
                }
            });
            this.initInterstitialView();
            this.initClickListener();
        }
    }

    private void initClickListener() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (KidozButtonView.this.mInterstitialView != null) {
                    GenAnimator.clickItemAnimation(KidozButtonView.this.mRootView, 100, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            KidozButtonView.this.mInterstitialView.showView();
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            }
        });
    }

    private void initInterstitialView() {
        if (this.getContext() instanceof FragmentActivity) {
            this.mInterstitialView = new InterstitialView.Builder(this.getContext(), ((FragmentActivity)this.getContext()).getSupportFragmentManager()).build();
        }
    }

    public InterstitialView getInterstitialView() {
        return this.mInterstitialView;
    }
}

