/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.ContentLogicLoader;
import com.kidoz.sdk.api.FeedVeiwFragmentDialog;
import com.kidoz.sdk.api.general.enums.UiStyleType;
import com.kidoz.sdk.api.interfaces.IOnInterstitialViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import java.util.ArrayList;

public class InterstitialView {
    private static final String TAG = InterstitialView.class.getSimpleName();
    private Builder mBuilder;
    private FeedVeiwFragmentDialog mFeedVeiwFragmentDialog;
    protected ContentLogicLoader mContentLogicLoader;
    private IOnInterstitialViewEventListener mOnInterstitialViewEventListener;

    private InterstitialView(Builder builder) {
        this.mBuilder = builder;
        Fragment existingDialog = this.mBuilder.mFragmentManager.findFragmentByTag(FeedVeiwFragmentDialog.TAG);
        this.mFeedVeiwFragmentDialog = existingDialog != null && existingDialog instanceof FeedVeiwFragmentDialog ? (FeedVeiwFragmentDialog)existingDialog : FeedVeiwFragmentDialog.newInstance();
        this.mFeedVeiwFragmentDialog.setOnCloseButtonClickListenr(new View.OnClickListener(){

            public void onClick(View view) {
                InterstitialView.this.dismissView();
            }
        });
        this.initContentLogicLoader();
    }

    private void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                int servedCounter = 0;
                if (contentData != null) {
                    ArrayList<ContentItem> contentItems = contentData.getContentDataItems();
                    if (contentItems != null && !contentItems.isEmpty()) {
                        for (ContentItem nextContentItem : contentItems) {
                            if (!nextContentItem.isPromoted()) continue;
                            ++servedCounter;
                        }
                    }
                    EventManager.getInstance().LogEventWithIntField(InterstitialView.this.mBuilder.mContext, EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Impression Served", null, servedCounter);
                }
                InterstitialView.this.mFeedVeiwFragmentDialog.setContentData(contentData);
                if (InterstitialView.this.mOnInterstitialViewEventListener != null) {
                    InterstitialView.this.mOnInterstitialViewEventListener.onReadyToShow();
                }
                InterstitialView.this.mFeedVeiwFragmentDialog.openDialog(InterstitialView.this.mBuilder.mFragmentManager);
            }
        });
    }

    public void showView() {
        this.mContentLogicLoader.loadContent(this.mBuilder.mContext, UiStyleType.FEED_VIEW_STYLE);
    }

    public void dismissView() {
        this.mFeedVeiwFragmentDialog.closeDialog(this.mBuilder.mFragmentManager);
        if (this.mOnInterstitialViewEventListener != null) {
            this.mOnInterstitialViewEventListener.onDismissView();
        }
    }

    public void setOnInterstitialViewEventListener(IOnInterstitialViewEventListener listener) {
        this.mOnInterstitialViewEventListener = listener;
    }

    public static class Builder {
        private FragmentManager mFragmentManager;
        private Context mContext;

        public Builder(Context context, FragmentManager fragmentManager) {
            this.mFragmentManager = fragmentManager;
            this.mContext = context;
        }

        public InterstitialView build() {
            return new InterstitialView(this);
        }
    }
}

