/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.ContentExecutionHandler;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.FeedFullVeiw;
import java.io.Serializable;

public class FeedVeiwFragmentDialog
extends DialogFragment {
    public static final String TAG = FeedVeiwFragmentDialog.class.getSimpleName();
    private static final String SAVE_DATA_INSTANCE_KEY = "SAVE_DATA_INSTANCE_KEY";
    private static final String SAVE_ORIGINAL_ORIENTATION_KEY = "SAVE_ORIGINAL_ORIENTATION_KEY";
    private FeedFullVeiw mFeedFullVeiw;
    private ContentData mContentData = null;
    private View.OnClickListener mCloseBtnClickListener = null;
    private int mCurrentOrientationState;
    private long mEventID;
    private boolean mImpressionServed;

    protected static FeedVeiwFragmentDialog newInstance() {
        FeedVeiwFragmentDialog f = new FeedVeiwFragmentDialog();
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int style2 = 2;
        int theme = 16973834;
        this.setStyle(style2, theme);
        this.setCancelable(true);
        if (savedInstanceState != null && savedInstanceState.containsKey(SAVE_ORIGINAL_ORIENTATION_KEY)) {
            this.mCurrentOrientationState = savedInstanceState.getInt(SAVE_ORIGINAL_ORIENTATION_KEY);
        } else {
            this.mCurrentOrientationState = this.getResources().getConfiguration().orientation;
            this.getActivity().setRequestedOrientation(4);
        }
        this.mImpressionServed = false;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().getAttributes().windowAnimations = R.style.FullViewInOutAnimation;
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4) {
                    if (FeedVeiwFragmentDialog.this.mFeedFullVeiw != null && FeedVeiwFragmentDialog.this.mFeedFullVeiw.getViewBottomBar().isAboutViewVisible()) {
                        FeedVeiwFragmentDialog.this.mFeedFullVeiw.getViewBottomBar().hideAboutView();
                    } else {
                        FeedVeiwFragmentDialog.this.closeDialog(FeedVeiwFragmentDialog.this.getFragmentManager());
                    }
                }
                return true;
            }
        });
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.mContentData == null && savedInstanceState != null && savedInstanceState.containsKey(SAVE_DATA_INSTANCE_KEY)) {
            this.mContentData = (ContentData)savedInstanceState.get(SAVE_DATA_INSTANCE_KEY);
        }
        this.mFeedFullVeiw = new FeedFullVeiw((Context)this.getActivity());
        this.mFeedFullVeiw.setOnContentItemClickListener(new AbstractContentPanel.IOnContentItemClickListener(){

            @Override
            public void onItemClick(ContentItem contentItem, int postion) {
                if (contentItem != null && contentItem.getContentType() != null && contentItem.getContentType() != ContentType.NONE) {
                    ContentExecutionHandler.handleContentItemClick((Context)FeedVeiwFragmentDialog.this.getActivity(), FeedVeiwFragmentDialog.this.getFragmentManager(), contentItem, postion);
                }
            }
        });
        this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        this.mFeedFullVeiw.setContentDataAndRefresh(this.mContentData);
        return this.mFeedFullVeiw;
    }

    protected void setContentData(ContentData contentData) {
        this.mContentData = contentData;
    }

    protected void setOnCloseButtonClickListenr(View.OnClickListener clickListenr) {
        this.mCloseBtnClickListener = clickListenr;
        if (this.mFeedFullVeiw != null) {
            this.mFeedFullVeiw.setOnCloseButtonClickListenr(this.mCloseBtnClickListener);
        }
    }

    protected void openDialog(FragmentManager fragmentManager) {
        if (KidozSDK.isInitialised()) {
            FragmentTransaction ft = fragmentManager.beginTransaction();
            ft.setTransition(4097);
            Fragment prev = fragmentManager.findFragmentByTag(TAG);
            if (prev != null) {
                ft.remove(prev);
            } else if (!this.isAdded()) {
                ft.addToBackStack(null);
                this.show(fragmentManager, TAG);
            }
            EventManager.getInstance().logEvent((Context)this.getActivity(), EventManager.LOG_CRITICAL_LEVEL, "Sponsored Content", "Widget View", null);
        }
    }

    protected void closeDialog(FragmentManager fragmentManager) {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.setTransition(8194);
        Fragment prev = fragmentManager.findFragmentByTag(TAG);
        if (prev != null) {
            ft.remove(prev);
        }
        this.restoreUserOriginalOrientation();
        if (this != null) {
            this.dismissAllowingStateLoss();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mContentData != null) {
            outState.putSerializable(SAVE_DATA_INSTANCE_KEY, (Serializable)this.mContentData);
            outState.putInt(SAVE_ORIGINAL_ORIENTATION_KEY, this.mCurrentOrientationState);
        }
    }

    public void onPause() {
        EventManager.getInstance().activityEnd(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, this.mEventID);
        super.onPause();
    }

    public void onResume() {
        super.onResume();
        this.mEventID = EventManager.getInstance().activityStart(this.getContext(), EventManager.LOG_CRITICAL_LEVEL, "FeedViewDialog");
    }

    private void restoreUserOriginalOrientation() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            switch (this.mCurrentOrientationState) {
                case 2: {
                    this.getActivity().setRequestedOrientation(6);
                    break;
                }
                case 1: {
                    this.getActivity().setRequestedOrientation(7);
                    break;
                }
                case 0: {
                    this.getActivity().setRequestedOrientation(4);
                }
            }
        }
    }
}

