/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventLogger;
import com.kidoz.events.EventManager;
import com.kidoz.events.SyncReciever;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.server_connect.ResultData;

public class SyncEventService
extends IntentService {
    public static final String TAG = SyncEventService.class.getSimpleName();
    private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
    private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 900000;
    private Intent mIntent;
    private boolean mSyncRunning = false;
    private boolean mContinueSyncProcces;
    private int munOfRetriesInCaseFailedCount = 1;
    private long mServiceSyncStartTime;

    public SyncEventService() {
        super("LogIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        EventLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
        if (intent != null && intent.hasExtra("STOP_SERVICE_EXTRA")) {
            this.mSyncRunning = false;
            this.mContinueSyncProcces = false;
        }
        if (!this.mSyncRunning) {
            EventLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            EventLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V4.0 ----------------------");
            EventLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
            this.mSyncRunning = true;
            this.mContinueSyncProcces = true;
            this.mServiceSyncStartTime = System.currentTimeMillis();
            EventLogger.printInfoLog("Log Events info:" + this.mSyncRunning + " , " + this.mContinueSyncProcces);
            while (EventManager.getInstance().getIsCanSendLog((Context)this) && this.isAllowedToRunTimeFrame() && this.mContinueSyncProcces) {
                EventLogger.printDebbugLog(">>>> SyncEventService : sending logs");
                EventBulk bulk = EventManager.getInstance().getNextBulk((Context)this);
                EventLogger.printInfoLog("Log Events Sync info : bulk value:" + bulk.toString());
                if (bulk != null) {
                    String json = bulk.toString();
                    if (json != null) {
                        ResultData<Boolean> resultCallback = KidozSDK.getApiManager((Context)this).sendKidozEventsToServerNotAsync(json);
                        if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful()) {
                            EventManager.getInstance().removeBulkFromDB((Context)this, bulk);
                            this.munOfRetriesInCaseFailedCount = 1;
                            continue;
                        }
                        if (this.munOfRetriesInCaseFailedCount <= 0) break;
                        EventLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
                        --this.munOfRetriesInCaseFailedCount;
                        continue;
                    }
                    EventLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
                    break;
                }
                EventLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
                break;
            }
        }
        this.mSyncRunning = false;
        this.removeWakefullLock();
    }

    public boolean isAllowedToRunTimeFrame() {
        return System.currentTimeMillis() - this.mServiceSyncStartTime < 900000L;
    }

    public void removeWakefullLock() {
        if (this.mIntent != null) {
            try {
                SyncReciever.completeWakefulIntent((Intent)this.mIntent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onDestroy() {
        this.mContinueSyncProcces = false;
        super.onDestroy();
    }
}

