/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.kidoz.events.DeviceUtils;
import com.kidoz.events.Event;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventLogDatabaseManager;
import com.kidoz.events.EventLogger;
import com.kidoz.events.EventParameters;
import com.kidoz.events.SyncEventService;
import com.kidoz.events.SyncReciever;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.zip.CRC32;
import org.json.JSONObject;

public class EventManager {
    public static int LOG_CRITICAL_LEVEL = 0;
    public static int LOG_NORMAL_LEVEL = 1;
    public static int LOG_CLOSE_ANY_EVENT_LEVEL = 0;
    public static int LOG_CLOSE_RESOURCE_LEVEL = 1;
    public static int LOG_CLOSE_ACTIVITY_LEVEL = 2;
    public static int LOG_CLOSE_SESSION_LEVEL = 3;
    private static final String TAG = EventManager.class.getSimpleName();
    public static final String SYNC_ALARM_INTENT = "kidoz.sync.alarm.event.action";
    public static final String STOP_SERVICE_EXTRA = "STOP_SERVICE_EXTRA";
    public static final int SYNC_ALARM_INTENT_REQUEST_CODE = 1982;
    private static final int SYNC_ALARM_INTERVAL_IN_MILLISECONDS = 300000;
    private static final int NIGHT_TIME_HOUR_VALUE_START = 21;
    private static final int NIGHT_TIME_HOUR_VALUE_END = 8;
    private static final int DAY_TIME_AMOUNT = 10;
    private static final int NIGHT_TIME_AMOUNT_EXTRA = 50;
    private static final int THREE_G_CONNECTON_TYPE_AMOUNT = 10;
    private static final int WIFI_CONNECTON_TYPE_AMOUNT_EXTRA = 20;
    private static final int SCREEN_STATE_ON_AMOUNT = 10;
    private static final int SCREEN_STATE_OFF_AMOUNT_EXTRA = 20;
    private static final String OS_TYPE = "Android";
    private static final long DEFAULT_DELTA_TIME_BETWEEN_ACTIVITES_FOR_NEW_SESSION = 30000L;
    public static final String EVENTS_SHARED_PREFERENCES_KEY = "events_shared_preferences";
    public static final String EVENTS_LAST_SESSION_ID_KEY = "last_session_id";
    private static final String EVENTS_LAST_ACTIVITY_ID_KEY = "last_activity_id";
    private static final String EVENT_SERVER_ADDRESS_KEY = "event_server_address";
    private static final String DELTA_FOR_NEW_SESSION_KEY = "delta_for_new_session_key";
    public static final String LOG_LEVEL_KEY = "log_level";
    private static EventManager mEventManager;
    private int mLogLevel;
    private String mServerAdress;
    private long mSessionID;
    private long mActivityID;
    private String mActivityName;
    private Date mLastEventTimeStamp;
    private Date mLastActivityEndTime;
    private String mDeveloperID;
    private ArrayList<Event> mOpenedEventsList = new ArrayList();
    private EventLogDatabaseManager mDatabaseManager;
    private boolean initialized = false;

    private EventManager() {
    }

    public static EventManager getInstance() {
        if (mEventManager == null) {
            mEventManager = new EventManager();
        }
        return mEventManager;
    }

    public void init(Context context, JSONObject params) {
        SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
        try {
            if (params != null) {
                this.mLogLevel = params.optInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                this.mServerAdress = params.optString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                this.mDeveloperID = params.optString("DeveloperID", "");
                this.mSessionID = params.optInt("SessionID", 0);
                SharedPreferences.Editor editor = eventsPref.edit();
                editor.putInt(LOG_LEVEL_KEY, this.mLogLevel);
                editor.putString("DeveloperID", this.mDeveloperID);
                editor.commit();
            } else {
                this.mLogLevel = eventsPref.getInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                this.mServerAdress = eventsPref.getString("serveraddress", EVENT_SERVER_ADDRESS_KEY);
                this.mDeveloperID = eventsPref.getString("DeveloperID", "");
                this.mSessionID = -1L;
            }
            this.mActivityID = 0L;
            if (this.mDatabaseManager == null) {
                this.mDatabaseManager = new EventLogDatabaseManager(context);
            }
            EventLogger.printInfoLog("init Event manager");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager init " + ex.getMessage());
        }
        this.initialized = true;
    }

    public void setSyncAlarm(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, SyncReciever.class);
        intent.setAction(SYNC_ALARM_INTENT);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1982, (Intent)intent, (int)0x8000000);
        Random random = new Random();
        long currentTimeInMilliseconds = Calendar.getInstance().getTimeInMillis();
        long triggerAtMillis = currentTimeInMilliseconds + (long)random.nextInt(300000) + 300000L;
        alarmManager.set(0, triggerAtMillis, pendingIntent);
    }

    public void cancelSyncAlarm(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        Intent intent = new Intent(context, SyncReciever.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1982, (Intent)intent, (int)0x20000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (intent != null) {
            alarmManager.cancel(pendingIntent);
        }
    }

    public void startSync(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        Intent intent = new Intent(context, SyncReciever.class);
        context.startService(intent);
    }

    public Intent getSyncServiceIntent(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        return new Intent(context, SyncEventService.class);
    }

    public boolean getIsCanSendLog(Context context) {
        boolean result = false;
        if (!this.initialized) {
            this.init(context, null);
        }
        if (BaseConnectionClient.isNetworkAvailable(context) && !this.mDatabaseManager.getEventsTable().isDBempty()) {
            result = true;
        }
        return result;
    }

    public EventBulk getNextBulk(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        EventBulk result = new EventBulk();
        result.setDeviceParamsJSONObject(this.getBulkDeviceParamsJsonObject(context));
        result.setEventArrayList(this.mDatabaseManager.getEventsTable().getEvents(this.calculateBulkSize(context)));
        return result;
    }

    public void removeBulkFromDB(Context context, EventBulk eventBulk) {
        if (!this.initialized) {
            this.init(context, null);
        }
        this.mDatabaseManager.getEventsTable().removeLogEventsFromDB(eventBulk.getEventArrayList());
    }

    private int calculateBulkSize(Context context) {
        if (!this.initialized) {
            this.init(context, null);
        }
        int result = 30;
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        if (currentHour >= 21 || currentHour <= 8) {
            result += 50;
        }
        if (BaseConnectionClient.getConnectionType(context) == 1) {
            result += 20;
        }
        if (ScreenUtils.getIsScreenOff(context)) {
            result += 20;
        }
        return result;
    }

    public long activityStart(Context context, int logLevel, String activityName) {
        try {
            if (!this.initialized) {
                this.init(context, null);
            }
            this.mLastEventTimeStamp = new Date();
            if (this.mLastActivityEndTime == null) {
                this.mLastActivityEndTime = new Date(0L);
            }
            Date lastEventTime = this.mLastEventTimeStamp;
            this.mLastEventTimeStamp = new Date();
            Long timeDelta = this.mLastEventTimeStamp.getTime() - this.mLastActivityEndTime.getTime();
            ++this.mActivityID;
            Event openedEvent = new Event();
            this.fillBaseEventParameters(openedEvent, "Activity", "Activity End", activityName);
            openedEvent.setLogLevel(LOG_CRITICAL_LEVEL);
            openedEvent.setCloseLevel(LOG_CLOSE_ACTIVITY_LEVEL);
            this.mOpenedEventsList.add(openedEvent);
            this.mActivityName = activityName;
            this.internalLogEvent(context, logLevel, null, "Activity", "Activity Start", activityName);
            EventLogger.printInfoLog("activity start event generated");
            return this.mActivityID;
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager activityStart " + ex.getMessage());
            return -1L;
        }
    }

    public int activityEnd(Context context, int logLevel, long activityID) {
        try {
            Date currentDate = new Date();
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getCloseLevel() > LOG_CLOSE_ACTIVITY_LEVEL) continue;
                long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", String.valueOf(duration));
                this.internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            EventLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager activity end " + ex.getMessage());
        }
        this.mLastActivityEndTime = new Date();
        return 0;
    }

    public int logClickEvent(Context context, String action, String label, String itemID, int position) {
        Event event = new Event();
        event.addParameterToJsonObject("ItemID", itemID);
        event.addParameterToJsonObject("ItemIndex", position);
        this.internalLogEvent(context, LOG_NORMAL_LEVEL, event, "Content Click", action, label);
        return 0;
    }

    public int logEvent(Context context, int logLevel, String category, String action, String label) {
        this.internalLogEvent(context, logLevel, null, category, action, label);
        return 0;
    }

    public int logEventWithDuration(Context context, int logLevel, int resourceID, int closeLevel, String category, String action, String label, String itemID) {
        try {
            Date currentDate = new Date();
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() != resourceID) continue;
                long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", duration);
                opendEvent.addParameterToJsonObject("ItemID", itemID);
                this.internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            EventLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        Event openedEvent = new Event();
        this.fillBaseEventParameters(openedEvent, category, action, label);
        openedEvent.setLogLevel(logLevel);
        openedEvent.setCloseLevel(closeLevel);
        openedEvent.setResourceID(resourceID);
        this.mOpenedEventsList.add(openedEvent);
        return 0;
    }

    public int logEventWithDurationEnd(Context context, int resourceID) {
        try {
            Date currentDate = new Date();
            Iterator<Event> iterator = this.mOpenedEventsList.iterator();
            while (iterator.hasNext()) {
                Event opendEvent = iterator.next();
                if (opendEvent.getResourceID() != resourceID) continue;
                long duration = currentDate.getTime() - opendEvent.getEventCreationTime();
                opendEvent.addParameterToJsonObject("Duration", String.valueOf(duration));
                this.internalLogEvent(context, opendEvent.getLogLevel(), opendEvent, null, null, null);
                iterator.remove();
            }
            EventLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        return 0;
    }

    public int logSponsoredContentImpressionEvent(Context context, String action, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("advertiser_id", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, LOG_CRITICAL_LEVEL, event, "Sponsored Content", action, label);
            return 0;
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentClickEvent(Context context, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("advertiser_id", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Click", label);
            return 0;
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentInstallEvent(Context context, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("advertiser_id", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Install Completed", label);
            return 0;
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int LogEventWithIntField(Context context, int logLevel, String category, String action, String label, int intField) {
        Event event = new Event();
        event.addParameterToJsonObject("intField", intField);
        return this.internalLogEvent(context, logLevel, event, category, action, label);
    }

    public int LogEvent(Context context, int logLevel, Event event, String category, String action, String label) {
        return this.internalLogEvent(context, logLevel, event, category, action, label);
    }

    private int internalLogEvent(Context context, int logLevel, Event event, String category, String action, String label) {
        if (logLevel <= this.mLogLevel) {
            Event tempEvent = event == null ? new Event() : event;
            this.fillBaseEventParameters(tempEvent, category, action, label);
            EventLogger.printInfoLog("Event sent to DB: " + tempEvent.getJSONObject().toString());
            this.mDatabaseManager.getEventsTable().inserLogEventToDB(tempEvent);
        }
        return 0;
    }

    private int fillBaseEventParameters(Event event, String category, String action, String label) {
        if (category != null) {
            event.addParameterToJsonObject("Category", category);
        }
        if (action != null) {
            event.addParameterToJsonObject("Action", action);
        }
        if (label != null) {
            event.addParameterToJsonObject("Label", label);
        }
        event.addParameterToJsonObject("ActivityName", this.mActivityName);
        event.addParameterToJsonObject("ActivityID", this.mActivityID);
        event.addParameterToJsonObject("SessionID", this.mSessionID);
        return 0;
    }

    private JSONObject getStaticDeviceParamsJsonObject(Context context) {
        JSONObject result = new JSONObject();
        try {
            String deviceID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            CRC32 crc = new CRC32();
            crc.update(deviceID.getBytes());
            result.put("DeviceHash", (Object)String.valueOf(crc.getValue()));
            result.put("DeviceType", (Object)String.valueOf(Build.DEVICE));
            result.put("DeviceBrand", (Object)String.valueOf(Build.MANUFACTURER));
            result.put("DeviceModel", (Object)String.valueOf(Build.MODEL));
            result.put("ScreenType", (Object)String.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
            result.put("ScreenSize", (Object)String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            result.put("DpiFactor", (Object)String.valueOf(metrics.densityDpi));
            result.put("ScreenW", (Object)String.valueOf(DeviceUtils.getScreenSize(context, true)));
            result.put("ScreenH", (Object)String.valueOf(DeviceUtils.getScreenSize(context, false)));
            result.put("OsType", (Object)String.valueOf(OS_TYPE));
            result.put("OsVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
            result.put("ConnectionType", (Object)EventParameters.convertConnectionTypeToString(BaseConnectionClient.getConnectionType(context)));
            result.put("DeviceLang", (Object)String.valueOf(Locale.getDefault().getLanguage()));
            result.put("TimeZone", (Object)EventParameters.getCurrentTimezoneOffset());
            result.put("Country", (Object)String.valueOf(Locale.getDefault().getCountry()));
            result.put("EventType", (Object)"Device Info");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog(TAG, "Error when trying to create device params: " + ex.getMessage());
        }
        return result;
    }

    private JSONObject getBulkDeviceParamsJsonObject(Context context) {
        JSONObject result = new JSONObject();
        try {
            String deviceID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            CRC32 crc = new CRC32();
            crc.update(deviceID.getBytes());
            result.put("DeviceHash", (Object)String.valueOf(crc.getValue()));
            result.put("UserRefferal", (Object)DeviceUtils.getDeviceReferral(context));
            result.put("PackageID", (Object)context.getPackageName());
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            result.put("AppVersion", (Object)String.valueOf(pInfo.versionName));
            result.put("AppID", (Object)String.valueOf(pInfo.packageName));
            if (this.mDeveloperID == null) {
                SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
                this.mDeveloperID = eventsPref.getString("DeveloperID", "");
            }
            result.put("DeveloperID", (Object)this.mDeveloperID);
            result.put("EventType", (Object)"Normal");
            result.put("EventVersion", 0);
            result.put("DeviceType", (Object)String.valueOf(Build.DEVICE));
            result.put("DeviceBrand", (Object)String.valueOf(Build.MANUFACTURER));
            result.put("DeviceModel", (Object)String.valueOf(Build.MODEL));
            result.put("ScreenType", (Object)String.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
            result.put("ScreenSize", (Object)String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            result.put("DpiFactor", (Object)String.valueOf(metrics.densityDpi));
            result.put("ScreenW", (Object)String.valueOf(DeviceUtils.getScreenSize(context, true)));
            result.put("ScreenH", (Object)String.valueOf(DeviceUtils.getScreenSize(context, false)));
            result.put("OsType", (Object)String.valueOf(OS_TYPE));
            result.put("OsVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
            result.put("ConnectionType", (Object)EventParameters.convertConnectionTypeToString(BaseConnectionClient.getConnectionType(context)));
            result.put("DeviceLang", (Object)String.valueOf(Locale.getDefault().getLanguage()));
            result.put("TimeZone", (Object)EventParameters.getCurrentTimezoneOffset());
            result.put("Country", (Object)String.valueOf(Locale.getDefault().getCountry()));
            result.put("EventType", (Object)"Device Info");
        }
        catch (Exception ex) {
            EventLogger.printErrorLog("Error when trying to create device params: " + ex.getMessage());
        }
        return result;
    }
}

