package com.kidoz.sdk.api.ui_views.parental_lock;

import android.animation.Animator;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.structure.LockIconData;

import java.io.File;
import java.util.ArrayList;

/**
 * Created by roni on 8/24/2015.
 */
public class LockIconsAdapter extends RecyclerView.Adapter<LockIconsAdapter.ViewHolder> implements View.OnClickListener
{
    private final String TAG = LockIconsAdapter.class.getSimpleName();

    private final int POP_UP_ANIMATION_DURATION = 40;
    private ArrayList<LockIconData> mContent;
    private int mItemSize;
    private boolean mIsCanClick;
    private LockIconAdapterListener mLockIconAdapterListener;

    // Animation related.
    private int mLastPosition = -1;
    private AccelerateInterpolator mAnimationInterpolator;

    private Handler mHandler;

    public LockIconsAdapter(ArrayList<LockIconData> content)
    {
        mHandler = new Handler();
        mContent = content;
        mIsCanClick = true;
        mAnimationInterpolator = new AccelerateInterpolator();
    }

    public synchronized void setContent(ArrayList<LockIconData> content)
    {
        synchronized (this)
        {
            if (content != null)
            {
                if (mContent.isEmpty() == true)
                {
                    mContent.clear();
                    mContent.addAll(content);
                    notifyItemRangeInserted(0, getItemCount());
                    notifyItemRangeChanged(0, getItemCount());
                }
                else
                {
                    mContent.clear();
                    mContent.addAll(content);
                    notifyDataSetChanged();
                }
            }
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder
    {
        private View mRootView;
        private ImageView mLockIconImageView;

        public ViewHolder(View rootView)
        {
            super(rootView);
            mRootView = rootView;
            mLockIconImageView = (ImageView) mRootView.findViewById(R.id.LockIconImageView);
        }
    }

    @Override public int getItemCount()
    {
        int result = 0;
        if (mContent != null)
        {
            result = mContent.size();
        }
        return result;
    }

    @Override public ViewHolder onCreateViewHolder(ViewGroup parent, int arg1)
    {
        mItemSize = parent.getWidth() / 4;
        View convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.lock_icon_item, parent, false);
        ViewHolder viewHolder = new ViewHolder(convertView);
        viewHolder.mRootView.setOnClickListener(this);
        viewHolder.mRootView.setTag(viewHolder);
        return viewHolder;
    }

    @Override public void onBindViewHolder(final ViewHolder viewHolder, int position)
    {
        LockIconData lockIconData = mContent.get(position);
        if (lockIconData != null)
        {
            fixItemSize(viewHolder);
            loadLockIcon(viewHolder, lockIconData);
        }

        if (position > mLastPosition)
        {
            long delay = position * POP_UP_ANIMATION_DURATION;
            viewHolder.mRootView.setVisibility(View.INVISIBLE);
            mHandler.postDelayed(new Runnable()
            {
                @Override public void run()
                {
                    GenAnimator.recycleItemAnimation(viewHolder.mRootView, new GenAnimator.ViewAnimationListener()
                    {
                        @Override public void onAnimationEnd()
                        {
                        }

                        @Override public void onAnimationStart()
                        {
                            viewHolder.mRootView.setVisibility(View.VISIBLE);
                        }
                    });

                }
            }, delay);
            mLastPosition = position;
        }
        else
        {
            viewHolder.mRootView.clearAnimation();
            viewHolder.mRootView.setVisibility(View.VISIBLE);
        }
    }

    private void fixItemSize(ViewHolder viewHolder)
    {
        viewHolder.mRootView.getLayoutParams().height = mItemSize;
        viewHolder.mRootView.getLayoutParams().width = mItemSize;
    }

    private void loadLockIcon(ViewHolder viewHolder, LockIconData lockIconData)
    {
        if (viewHolder != null && lockIconData != null)
        {
            try
            {
                File dir = viewHolder.mRootView.getContext().getFilesDir();
                File imageFile = new File(dir, lockIconData.getIconURL());
                PicassoOk.getPicasso(viewHolder.mLockIconImageView.getContext()).load(imageFile).into(viewHolder.mLockIconImageView);
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to load lock icon: " + ex.getMessage());
            }
        }
    }


    @Override public void onClick(final View view)
    {
        if (mIsCanClick == true)
        {
            mIsCanClick = false;

            AnimationsUtils.animateClick(view, new Animator.AnimatorListener()
            {
                @Override public void onAnimationStart(Animator animation)
                {
                }

                @Override public void onAnimationEnd(Animator animation)
                {
                    final ViewHolder viewHolder = (ViewHolder) view.getTag();
                    int position = viewHolder.getAdapterPosition();
                    if (position == RecyclerView.NO_POSITION)
                    {
                        position = viewHolder.getPosition();
                    }
                    if (position != RecyclerView.NO_POSITION)
                    {
                        if (mLockIconAdapterListener != null)
                        {
                            mLockIconAdapterListener.onLockIconClick(position);
                        }
                    }
                    mIsCanClick = true;
                }

                @Override public void onAnimationCancel(Animator animation)
                {

                }

                @Override public void onAnimationRepeat(Animator animation)
                {

                }
            });
        }
    }

    public void setLockIconAdapterListener(LockIconAdapterListener lockIconAdapterListener)
    {
        mLockIconAdapterListener = lockIconAdapterListener;
    }

    public interface LockIconAdapterListener
    {
        public void onLockIconClick(int index);
    }
}
