package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;

/**
 * Created by roni on 8/26/2015.
 */
public class OnBoardingCloud extends RelativeLayout
{
    public static final String ON_BOARDING_SHARED_PREFERENCES_KEY = "ON_BOARDING_SHARED_PREFERENCES_KEY";
    private final long ON_BOARDING_ENTER_DELAY_ANIMATION = 500;
    private final long ON_BOARDING_EXIT_DELAY_ANIMATION = 2200;
    private final long FADE_IN_ANIMATION_DURATION = 1000;
    private final long FADE_OUT_ANIMATION_DURATION = 700;

    private View mBackgroundView;
    private View mAnimationView;
    private View mRootView;
    private OnBoardingCloudInterface mOnBoardingCloudInterface;

    public OnBoardingCloud(Context context)
    {
        super(context);
        initView();
    }

    private void initView()
    {
        initRootView();
        initBackgroundView();
        initAnimationView();
    }

    private void initBackgroundView()
    {
        mBackgroundView = mRootView.findViewById(R.id.BackgroundView);
        mBackgroundView.setClickable(true);
        mBackgroundView.setVisibility(View.INVISIBLE);
    }

    private void initAnimationView()
    {
        mAnimationView = mRootView.findViewById(R.id.AnimationView);
        mAnimationView.setVisibility(View.INVISIBLE);
    }


    private void initRootView()
    {
        mRootView = LayoutInflater.from(getContext()).inflate(R.layout.on_boarding_cloud, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        addView(mRootView, params);
    }

    public void animateView(final OnBoardingCloudInterface onBoardingCloudInterface)
    {
        mOnBoardingCloudInterface = onBoardingCloudInterface;
        postDelayed(new Runnable()
        {
            @Override public void run()
            {
                com.kidoz.sdk.api.players.video_player.util.AnimationsUtils.animateFade(mBackgroundView, true, FADE_IN_ANIMATION_DURATION, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {
                        mBackgroundView.setVisibility(View.VISIBLE);
                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {

                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });

                GenAnimator.playOnBoardingCloudDropAnimation(mAnimationView, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {
                        mAnimationView.setVisibility(View.VISIBLE);
                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {
                        OnBoardingCloud.this.postDelayed(new Runnable()
                        {
                            @Override public void run()
                            {
                                com.kidoz.sdk.api.players.video_player.util.AnimationsUtils.animateFade(mBackgroundView, false, FADE_OUT_ANIMATION_DURATION, new Animator.AnimatorListener()
                                {
                                    @Override public void onAnimationStart(Animator animation)
                                    {
                                    }

                                    @Override public void onAnimationEnd(Animator animation)
                                    {
                                        mBackgroundView.setVisibility(View.GONE);
                                        if (mOnBoardingCloudInterface != null)
                                        {
                                            mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    @Override public void onAnimationCancel(Animator animation)
                                    {
                                        mBackgroundView.setVisibility(View.GONE);
                                        if (mOnBoardingCloudInterface != null)
                                        {
                                            mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    @Override public void onAnimationRepeat(Animator animation)
                                    {

                                    }
                                });

                                GenAnimator.playPopOutAnimation(mAnimationView, new Animator.AnimatorListener()
                                {
                                    @Override public void onAnimationStart(Animator animation)
                                    {
                                    }

                                    @Override public void onAnimationEnd(Animator animation)
                                    {
                                        mAnimationView.setVisibility(View.GONE);
                                    }

                                    @Override public void onAnimationCancel(Animator animation)
                                    {
                                    }

                                    @Override public void onAnimationRepeat(Animator animation)
                                    {
                                    }
                                });
                            }
                        }, ON_BOARDING_EXIT_DELAY_ANIMATION);
                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        }, ON_BOARDING_ENTER_DELAY_ANIMATION);
    }

    public interface OnBoardingCloudInterface
    {
        public void onFinished();
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
    }
}
