package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.structure.ContentItem;

import java.util.ArrayList;

/**
 * Created by Eugine on 8/10/2015.
 */
public class ContentHorizontalPanelView extends AbstractContentPanel {

    public static final int INNER_RECYCLER_VIEW_MARGIN_DP = 2;
    public static final int INNER_RECYCLER_VIEW_PADDING_DP = 2;

    private ItemHorizontalRecycleViewAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private IOnContentItemClickListener mClickListener;

    private int mViewRealHeight = -1;

    private int mPadding;
    private int mMargin;

    private ArrayList<ContentItem> mContentItems = new ArrayList<ContentItem>();

    public ContentHorizontalPanelView(Context context, int height) {
        super(context);
        initPanelView(context);
        mViewRealHeight = height;
    }

    public ContentHorizontalPanelView(Context context) {
        super(context);
        initPanelView(context);
    }

    public ContentHorizontalPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ContentHorizontalPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initPanelView(Context context) {

        mPadding = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, INNER_RECYCLER_VIEW_PADDING_DP);
        mMargin = com.kidoz.sdk.api.general.utils.Utils.dpTOpx(context, INNER_RECYCLER_VIEW_MARGIN_DP);

        mRecyclerView = new RecyclerView(getContext());

        mLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mRecyclerView.setLayoutManager(mLayoutManager);
        mRecyclerView.setHasFixedSize(true);
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mRecyclerView.setPadding(mPadding, mPadding, mPadding, mPadding);

        reinstaniateAdapter();

        LinearLayout mLinearLayout = new LinearLayout(context);
        mLinearLayout.setGravity(Gravity.CENTER_VERTICAL);

        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        linParams.setMargins(0, mMargin, 0, mMargin);
        mLinearLayout.addView(mRecyclerView, linParams);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        addView(mLinearLayout, params);

        if (mViewRealHeight == -1) {
            getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
                @Override
                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    } else {
                        getViewTreeObserver().removeGlobalOnLayoutListener(this);
                    }

                    mViewRealHeight = getHeight() - mMargin * 2 - mPadding * 2;
                    reinstaniateAdapter();
                }
            });
        }
    }

    // Create new adapter with correct item size
    private void reinstaniateAdapter() {
        mAdapter = new ItemHorizontalRecycleViewAdapter(getContext(), mContentItems, mViewRealHeight);
        if (mClickListener != null) {
            mAdapter.setOnItemClickListener(mClickListener);
        }

        mRecyclerView.setAdapter(mAdapter);
    }

    /**
     * Set on contetn item click listener
     *
     * @param contentListener content click listener
     */
    public void setOnContentItemClickListener(IOnContentItemClickListener contentListener) {
        mClickListener = contentListener;
        if (mAdapter != null) {
            mAdapter.setOnItemClickListener(contentListener);
        }
    }

    /**
     * Set content to be shown
     *
     * @param content
     */
    public void setContent(final ArrayList<ContentItem> content) {
        if (mAdapter != null) {
            mAdapter.setContentData(content, false);
            mLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
            mRecyclerView.setLayoutManager(mLayoutManager);
        }
    }


    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        mLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mRecyclerView.setLayoutManager(mLayoutManager);
    }

    /**
     * Is has content in view
     *
     * @return true or false
     */
    public boolean isEmpty() {
        return  mContentItems.isEmpty();
    }
}
