package com.kidoz.sdk.api.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;

/**
 * Created by roni on 8/9/2015.
 */
public class SdkReceiver extends BroadcastReceiver
{
    private final String TAG = SdkReceiver.class.getSimpleName();

    @Override public void onReceive(Context context, Intent intent)
    {
        if (intent != null)
        {
            String action = intent.getAction();
            if (action != null)
            {
                if (action.equalsIgnoreCase(Intent.ACTION_PACKAGE_ADDED))
                {
                    if (intent.getData() != null)
                    {
                        String packageName = intent.getData().getSchemeSpecificPart();
                        if (packageName != null)
                        {
                            String clickedPromotedAppPackageName = SharedPreferencesUtils.loadSharedPreferencesData(context, SharedPreferencesUtils.PROMOTED_APP_PACKAGE_NAME);
                            if (clickedPromotedAppPackageName != null && clickedPromotedAppPackageName.equals(packageName) == true)
                            {
//                                LogEventHelper.logEventForSponsoredContent(context, LogParameters.TYPE_EVENT, LogParameters.CATEGORY_SPONSORED_CONTENT, LogParameters.ACTION_PROMOTED_APP_INSTALL_COMPLETE, clickedPromotedAppPackageName, clickedPromotedAppPackageName);
                                EventManager.getInstance().logSponsoredContentInstallEvent(context, clickedPromotedAppPackageName, "???", clickedPromotedAppPackageName,-1);
                            }
                        }
                    }
                }
            }
        }
        SharedPreferencesUtils.removeSharedPreferencesData(context, SharedPreferencesUtils.PROMOTED_APP_PACKAGE_NAME);
    }
}
