package com.kidoz.sdk.api.players.web_player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebSettings.LayoutAlgorithm;
import android.webkit.WebSettings.PluginState;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;


/**
 * Created by orikam on 7/15/15.
 */
public class KidozWebView extends WebView
{
    protected final static String HTTP = "http://";
    protected final static String HTTPS = "https://";
    protected final static String WWW = "www.";
    protected final static String WWW2 = "www2.";
    protected final static String KIDOZ_DOMAIN = "kidoz";
    protected final static List<String> PREFIXES_TO_REMOVE = new LinkedList<String>();

    {
        PREFIXES_TO_REMOVE.add(HTTP);
        PREFIXES_TO_REMOVE.add(HTTPS);
        PREFIXES_TO_REMOVE.add(WWW);
        PREFIXES_TO_REMOVE.add(WWW2);
    }


    private final String TAG = KidozWebView.class.getSimpleName();
    private static int API = Build.VERSION.SDK_INT;
    private Context mContext;
    private ArrayList<String> mAllowedSitesKeyWords = new ArrayList<String>();
    private static SharedPreferences mPreferences;

    private IOnLounchExternalAppFromRedirectListener onLounchExternalAppFromRedirectListener;
    //private ProgressDialog barProgressDialog;
    // private IOnDownloadApkFileFinishedListener finishedListener;

    private WebPlayerType mWebPlayerType = WebPlayerType.WEB_BROWSER;
    private String mGooglePlayAppId = null;


    public KidozWebView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        mContext = context;

        initWebView();

        initForTarget(mWebPlayerType);
    }


    public KidozWebView(Context context, WebPlayerType webPlayerType)
    {
        super(context);
        mContext = context;

        mWebPlayerType = webPlayerType;
        initWebView();

        initForTarget(webPlayerType);
    }

    public void initForTarget(WebPlayerType webPlayerType)
    {
        if (webPlayerType != null)
        {
            switch (webPlayerType)
            {
                case ONLINE_GAME:
                {
                    initOnlineGameSettings(getContext());
                    break;
                }

                case WEB_BROWSER:
                {
                    initializeGeneralSettingsState(getContext());
                    break;
                }

                case EXTERNAL_LINK:
                {
                    initializeGeneralSettingsState(getContext());
                    break;
                }
            }
        }
    }

    @SuppressWarnings("deprecation")
    @SuppressLint({"SetJavaScriptEnabled", "NewApi"})
    public void initializeGeneralSettingsState(Context context)
    {
        if (API < 18)
        {
            getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17)
        {
            getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17)
        {
            getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (API < 19)
        {
            getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        getSettings().setDomStorageEnabled(true);
        getSettings().setAppCacheEnabled(true);
        getSettings().setAppCachePath(context.getCacheDir().toString());
        getSettings().setCacheMode(WebSettings.LOAD_DEFAULT);
        getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        getSettings().setAllowFileAccess(true);
        getSettings().setDatabaseEnabled(true);
        getSettings().setSupportZoom(true);
        getSettings().setBuiltInZoomControls(true);
        getSettings().setDisplayZoomControls(false);
        getSettings().setAllowContentAccess(true);
        getSettings().setDefaultTextEncodingName("utf-8");
        if (API >= 16)
        {
            getSettings().setAllowFileAccessFromFileURLs(false);
            getSettings().setAllowUniversalAccessFromFileURLs(false);
        }

        mPreferences = context.getSharedPreferences(WebPreferenceConstants.PREFERENCES, 0);

        getSettings().setGeolocationEnabled(mPreferences.getBoolean(WebPreferenceConstants.LOCATION, false));
        if (API < 19)
        {

            switch (mPreferences.getInt(WebPreferenceConstants.ADOBE_FLASH_SUPPORT, 0))
            {
                case 0:
                    getSettings().setPluginState(PluginState.OFF);
                    break;
                case 1:
                    getSettings().setPluginState(PluginState.ON_DEMAND);
                    break;
                case 2:
                    getSettings().setPluginState(PluginState.ON);
                    break;
                default:
                    break;
            }
        }

        if (mPreferences.getBoolean(WebPreferenceConstants.SAVE_PASSWORDS, false))
        {
            if (API < 18)
            {
                getSettings().setSavePassword(true);
            }
            getSettings().setSaveFormData(true);
        }

        if (mPreferences.getBoolean(WebPreferenceConstants.JAVASCRIPT, true))
        {
            getSettings().setJavaScriptEnabled(true);
            getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        }

        if (mPreferences.getBoolean(WebPreferenceConstants.TEXT_REFLOW, false))
        {
            getSettings().setLayoutAlgorithm(LayoutAlgorithm.NARROW_COLUMNS);
        } else if (API >= Build.VERSION_CODES.KITKAT)
        {
            getSettings().setLayoutAlgorithm(LayoutAlgorithm.TEXT_AUTOSIZING);
        } else
        {
            getSettings().setLayoutAlgorithm(LayoutAlgorithm.NORMAL);
        }

        getSettings().setBlockNetworkImage(mPreferences.getBoolean(WebPreferenceConstants.BLOCK_IMAGES, false));
        getSettings().setSupportMultipleWindows(mPreferences.getBoolean(WebPreferenceConstants.POPUPS, true));
        getSettings().setUseWideViewPort(mPreferences.getBoolean(WebPreferenceConstants.USE_WIDE_VIEWPORT, true));
        getSettings().setLoadWithOverviewMode(mPreferences.getBoolean(WebPreferenceConstants.OVERVIEW_MODE, true));
        switch (mPreferences.getInt(WebPreferenceConstants.TEXT_SIZE, 3))
        {
            case 1:
                getSettings().setTextZoom(200);
                break;
            case 2:
                getSettings().setTextZoom(150);
                break;
            case 3:
                getSettings().setTextZoom(100);
                break;
            case 4:
                getSettings().setTextZoom(75);
                break;
            case 5:
                getSettings().setTextZoom(50);
                break;
        }

        if (Build.VERSION.SDK_INT > 10)
        {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);

        }

    }


    public synchronized void initOnlineGameSettings(Context context)
    {

        if (API < 18)
        {
            getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17)
        {
            getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17)
        {
            getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        if (API < 19)
        {
            getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }

        getSettings().setJavaScriptEnabled(true);
        getSettings().setLoadWithOverviewMode(true);
        getSettings().setAllowContentAccess(true);
        getSettings().setUserAgentString("Mozilla/5.0 (Linux; Android 4.4; Nexus 4 Build/KRT16H) AppleWebKit/537.36(KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36");

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP)
        {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else
        {
            setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }

        getSettings().setUseWideViewPort(false);
        //ooOri todo: complete this function no PreferenceConstants
        if (Build.VERSION.SDK_INT < 18)
        {
            getSettings().setPluginState(PluginState.ON);
        }

        getSettings().setDomStorageEnabled(true);
        getSettings().setAllowFileAccess(true);

        clearHistory();
        clearFormData();

        if (API >= Build.VERSION_CODES.KITKAT)
        {
            getSettings().setLayoutAlgorithm(LayoutAlgorithm.TEXT_AUTOSIZING);
        } else
        {
            getSettings().setLayoutAlgorithm(LayoutAlgorithm.NORMAL);
        }
    }

    @SuppressLint("NewApi")
    private void initWebView()
    {
        setDrawingCacheBackgroundColor(0x00000000);
        setFocusableInTouchMode(true);
        setFocusable(true);

        setAnimationCacheEnabled(true);
        setDrawingCacheEnabled(true);

        setBackgroundColor(mContext.getResources().getColor(android.R.color.white));

        if (API > 15)
        {
            setBackground(null);
            getRootView().setBackground(null);
        } else
        {
            getRootView().setBackgroundDrawable(null);
        }

        setWillNotCacheDrawing(false);
        setAlwaysDrawnWithCacheEnabled(true);
        setScrollbarFadingEnabled(true);
        setSaveEnabled(true);

        setWebChromeClient(new WebChromeClient()
        {

        });

        initWebChromeClient();
    }

    // Initiate web chrome client
    private void initWebChromeClient()
    {
        setWebViewClient(new WebViewClient()
        {
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon)
            {
                // TODO Auto-generated method stub
                super.onPageStarted(view, url, favicon);
            }

            @Override
            public void onPageFinished(WebView view, String url)
            {
                //ooOri todo: complete this function
                super.onPageFinished(view, url);

            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url)
            {
                boolean result = true;
                if (mWebPlayerType == WebPlayerType.ONLINE_GAME || mWebPlayerType == WebPlayerType.WEB_BROWSER)
                {
                    result = !checkIfSafeUrl(url);
                } else if (mWebPlayerType == WebPlayerType.EXTERNAL_LINK)
                {
                    if (url.contains("market://") || url.contains("play.google.com") && mGooglePlayAppId != null)
                    {
                        try
                        {
                            String googlePlayMarketURL = "market://details?id=" + mGooglePlayAppId;
                            String[] urlPazzel = url.split(mGooglePlayAppId);
                            if (urlPazzel != null && urlPazzel.length > 1)
                            {
                                googlePlayMarketURL += urlPazzel[1];
                            }

                            Intent intent = new Intent(Intent.ACTION_VIEW);
                            intent.setData(Uri.parse(googlePlayMarketURL));
                            // Used for notifing the the webview holder that the webiew is lounching and external application die to redirect link
                            // there fore it need to be closed
                            if (onLounchExternalAppFromRedirectListener != null)
                            {
                                onLounchExternalAppFromRedirectListener.onLounch();
                            }
                            mContext.startActivity(intent);
                        } catch (Exception ex)
                        {
                            com.kidoz.sdk.api.general.utils.SDKLogger.printErrorLog(TAG, "Error when trying to open google play for promoted app: \n" + ex.getMessage());
                        }
                        result = true;
                    } else
                    {
                        view.loadUrl(url);
                        result = true;
                    }
                }
                return result;
            }
        });
    }


    public void loadWebUrl(String url, String googlePlayAppID)
    {
        mAllowedSitesKeyWords.clear();
        mAllowedSitesKeyWords.add(url);
        mGooglePlayAppId = googlePlayAppID;
        loadUrl(url);
    }

    @Override
    public void onResume()
    {
        super.onResume();
    }

    @Override
    public void onPause()
    {

        stopLoading();
        super.onPause();
    }

    public synchronized void onDestroy()
    {
        stopLoading();
        clearHistory();
        removeAllViews();
        destroyDrawingCache();
    }


    private boolean checkIfSafeUrl(String url)
    {
        boolean result = false;
        if (url != null)
        {
            if (url.contains(KIDOZ_DOMAIN) == true)
            {
                result = true;
            } else
            {
                String urlStringWithoutPrefix = removePrefix(url);
                String fixedUrlString = urlStringWithoutPrefix.toLowerCase(Locale.US);
                if (mAllowedSitesKeyWords != null)
                {
                    for (int i = 0; i < mAllowedSitesKeyWords.size(); i++)
                    {
                        String originalUrl = removePrefix(mAllowedSitesKeyWords.get(i));
                        if (fixedUrlString.contains(originalUrl.toLowerCase(Locale.US)))
                        {
                            result = true;
                            break;
                        }
                    }
                } else
                {
                    com.kidoz.sdk.api.general.utils.SDKLogger.printDebbugLog(TAG, "Web Player  Not allowed link!");
                }
            }
        }
        return result;
    }


    /**
     * @param urlString - The WEBSITE_URL string we want modified
     * @return A modified WEBSITE_URL without all the prefixes:
     * will all return globes.co.il
     */
    private static String removePrefix(String urlString)
    {
        try
        {
            String modifiedString = urlString.toLowerCase();
            for (String prefixToRemove : PREFIXES_TO_REMOVE)
            {
                if (modifiedString.startsWith(prefixToRemove))
                {
                    int lenght = modifiedString.length();
                    modifiedString = modifiedString.substring(prefixToRemove.length(), lenght);
                }
            }
            return modifiedString;
        } catch (Exception e)
        {
            return null;
        }
    }

    public synchronized void stopAndReleaseWebView()
    {
        loadUrl("");
        stopLoading();
        clearHistory();
        removeAllViews();
        destroyDrawingCache();
    }


    /**
     * Listener for notifing the the webview holder that the webiew is lounching and external application
     */
    public interface IOnLounchExternalAppFromRedirectListener
    {
        public void onLounch();
    }

    /**
     * Set on lounch external application listener*
     *
     * @param listener click listener
     */
    public void setOnLounchExternalAppFromRedirect(IOnLounchExternalAppFromRedirectListener listener)
    {
        onLounchExternalAppFromRedirectListener = listener;
    }
}
//ooOri todo: complete this function no PreferenceConstants
//    private void doanloadApkFile(String fileUrl)
//    {
//        final File filePath = new File(getTempDownloadFolderPath().getAbsoluteFile() + File.separator + "temp.apk");
//
//        KidozApplication.getApplicationInstance().getKidozApiManager().downloadFileFromUrl(fileUrl, filePath, new DownloadFileListener()
//        {
//            @Override
//            public void onDownloadStart()
//            {
//
//                if (barProgressDialog == null)
//                {
//                    barProgressDialog = new ProgressDialog(mContext);
//                    barProgressDialog.setTitle("Downloading ...");
//                    barProgressDialog.setMessage("Download in progress ...");
//                    barProgressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
//                    barProgressDialog.setProgress(0);
//                    barProgressDialog.setCancelable(false);
//                    barProgressDialog.setMax(100);
//                }
//
//                barProgressDialog.show();
//            }
//
//            @Override
//            public void onInitiatlFileSize(int size)
//            {
//                barProgressDialog.setProgress(0);
//            }
//
//            @Override
//            public void onDownloadProgress(int progress, int progressPercents, boolean finished)
//            {
//                barProgressDialog.setProgress(progressPercents);
//            }
//
//            @Override
//            public void onDownloadEnd(boolean success)
//            {
//                if (finishedListener != null)
//                {
//                    finishedListener.onDownloadApkFinished();
//                }
//                barProgressDialog.dismiss();
//                PackageUtils.install(mContext, filePath.getAbsolutePath());
//            }
//        });
//    }
//ooOri todo: complete this function
//    private static File getTempDownloadFolderPath()
//    {
//        final String KIDOZ_DEFAULT_TEMO_DL_FOLDER_NAME = "Kids/Temp/Apps";
//
//        File file = DeviceUtils.getWritableExternalStorageFilePath();
//        File dlFolderPath = new File(file.getAbsolutePath() + File.separator + KIDOZ_DEFAULT_TEMO_DL_FOLDER_NAME);
//        if (!dlFolderPath.exists())
//        {
//            dlFolderPath.mkdirs();
//        }
//
//        AppLogger.printWarningLog("FILE PATH: " + dlFolderPath.getAbsolutePath());
//        return dlFolderPath;
//    }

   /* public void setOnDownloadApkFileFinishedListener(IOnDownloadApkFileFinishedListener listener) {
        finishedListener = listener;
    }

    public interface IOnDownloadApkFileFinishedListener {
        public void onDownloadApkFinished();
    }*/

//           case PARENTAL_CONTROL:
//           {
//                initializeGeneralSettingsState(getSettings(), mContext);
//                if (Build.VERSION.SDK_INT < 18)
//                {
//                    getSettings().setPluginState(PluginState.ON);
//                    getSettings().setRenderPriority(RenderPriority.HIGH);
//                }
//
//                if (android.os.Build.VERSION.SDK_INT < 18)
//                {
//                    getSettings().setDefaultZoom(ZoomDensity.FAR);
//                }
//                else
//                {
//                    getSettings().setUseWideViewPort(true);
//                }
//                break;
//           }

//                if (mContentItem != null)
//                {
//
//                    }
//                    else
//                    {
//                        boolean allowed = WebViewHelperUtils.isUrlAllowed(mAllowedSitesKeyWords, url);
//                        if (allowed)
//                        {
//                            if (url.endsWith(".apk"))
//                            {
//                                doanloadApkFile(url);
//                            }
//                            result = false;
//                        }
//                        else
//                        {
//                            LogEventHelperTypeClick.sendBlockOperationLog(mContext, LogParameters.LABEL_URL_BLOCKED, LogEventHelper.convertContentItemToScreenName(mContentItem, false), url);
//                            Toast.makeText(mContext, "BLOCKED WEBSITE_URL: \n" + url + "\n", Toast.LENGTH_LONG).show();
//                        }
//                    }
//                }
//                else
//                {
//                    boolean allowed = WebViewHelperUtils.isUrlAllowed(mAllowedSitesKeyWords, url);
//                    if (allowed)
//                    {
//                        if (url.endsWith(".apk"))
//                        {
//                            doanloadApkFile(url);
//                        }
//                        result = false;
//                    }
//                    else
//                    {
//                        LogEventHelperTypeClick.sendBlockOperationLog(mContext, LogParameters.LABEL_URL_BLOCKED, LogEventHelper.convertContentItemToScreenName(mContentItem, false), url);
//                        Toast.makeText(mContext, "BLOCKED WEBSITE_URL: \n" + url + "\n", Toast.LENGTH_LONG).show();
//                    }
//                }