package com.kidoz.sdk.api.players.video_player.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.media.ThumbnailUtils;
import android.net.Uri;

import java.io.File;


/**
 * Created by roni on 7/8/2015.
 */
public class ImageUtil
{
    public static Uri prepareCorrectUri(Object res)
    {
        if (res != null)
        {
            if (res instanceof Uri)
            {
                return (Uri) res;
            }
            else if (res instanceof Integer)
            {
                return Uri.parse("res:///" + (Integer) res);
            }
            else if (res instanceof File)
            {
                return Uri.fromFile((File) res);
            }
            else
            {
                int val = -1;
                try
                {
                    val = Integer.parseInt((String) res);
                }
                catch (NumberFormatException nfe)
                {
                }

                if (val != -1)
                {
                    return Uri.parse("res:///" + val);
                }
                else
                {
                    if (((String) res).startsWith("http://") || ((String) res).startsWith("https://"))
                    {
                        return Uri.parse((String) res);
                    }
                    else
                    {
                        if (((String) res).contains("mnt/") || ((String) res).contains("storage/"))
                        {
                            return Uri.fromFile(new File(((String) res)));
                        }
                        else
                        {
                            return Uri.parse("asset:///" + (String) res);
                        }
                    }
                }
            }
        }
        else
        {
            return Uri.EMPTY;
        }
    }

    public static Bitmap getMaskedBitmap(Context context, Bitmap originalBitmap, int maskImageID)
    {
        Bitmap result = null;
        if (originalBitmap != null)
        {
            // 1. Create the mask bitmap
            Bitmap maskBitmap = BitmapFactory.decodeResource(context.getResources(), maskImageID);
            result = Bitmap.createBitmap(maskBitmap.getWidth(), maskBitmap.getHeight(), Bitmap.Config.ARGB_8888);

            // 2. Prepare the original bitmap
            originalBitmap = ThumbnailUtils.extractThumbnail(originalBitmap, maskBitmap.getWidth(), maskBitmap.getHeight());

            // 3. Mask the bitmap
            if (maskBitmap != null)
            {
                Canvas canvas = new Canvas(result);
                Paint paint = new Paint();
                paint.setFilterBitmap(true);
                paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                paint.setDither(true);
                canvas.drawBitmap(maskBitmap, 0, 0, null);
                canvas.drawBitmap(originalBitmap, 0, 0, paint);
            }
        }
        return result;
    }

}
