package com.kidoz.sdk.api.players.video_player.ui.fragments;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.custom_views.KidozTopBar;
import com.kidoz.sdk.api.players.video_player.logics.VIDEO_PLAYER_TYPE;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.VideoPlayerController;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;

import java.util.ArrayList;


/**
 * Created by roni on 7/7/2015.
 */
public class VideoPlayerFragment extends Fragment
{
    public final static String TAG = VideoPlayerFragment.class.getSimpleName();
    private VIDEO_PLAYER_TYPE mVideoPlayerType = VIDEO_PLAYER_TYPE.YOUTUBE;
    private View mRootView;
    protected VideoPlayerController mVideoPlayerController;
    private VideoFragment mVideoFragment;
    private FrameLayout mVideoPlayerContainerFrameLayout;
    private VideoPlayerListener mVideoPlayerListener;
    private String mCurrentVideoID;
    private String mKidAvatarURL;
    private String mVideoName;
    private String mNumberOfLikes;
    private boolean mIsLiked;
    private ContentPanelView.IOnContentItemClickListener mRelatedContentListener;

    @Override public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        mRootView = inflater.inflate(R.layout.video_player_fragment, container, false);
        initFragment();
        return mRootView;
    }

    private void initFragment()
    {
        initAnchor();
        initVideoPlayerController();
        initVideoPlayerContainerFrameLayout();
        initVideoFragment();
    }

    private void initAnchor()
    {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(getActivity(), true), (ScreenUtils.getScreenSize(getActivity(), false)));
        int height = (int) (screenMaxSize * KidozTopBar.BACKGROUND_RATIO);

        View anchorView = mRootView.findViewById(R.id.AnchorView);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, height);
        anchorView.setLayoutParams(params);
    }


    private void initVideoPlayerController()
    {
        mVideoPlayerController = new VideoPlayerController(getActivity());
    }

    private void initVideoPlayerContainerFrameLayout()
    {
        mVideoPlayerContainerFrameLayout = (FrameLayout) mRootView.findViewById(R.id.VideoContainerFrameLayout);
    }

    private void initVideoFragment()
    {
        if (mVideoPlayerType != null)
        {
            switch (mVideoPlayerType)
            {
                case YOUTUBE:
                {
                    initYoutubeVideoPlayer();
                    break;
                }
            }
        }
    }

    private void initYoutubeVideoPlayer()
    {
        mVideoFragment = VideoFragment.newInstance();
        FragmentTransaction fragmentTransaction = getFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.VideoContainerFrameLayout, mVideoFragment, VideoFragment.TAG);
        fragmentTransaction.commit();
        mVideoPlayerController.setVideoFragment(mVideoFragment, mVideoPlayerContainerFrameLayout);
    }

    @Override public void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        ScreenUtils.hideNavigationAndStatusBar(getActivity().getWindow());
        mVideoPlayerController.fixVideoLayout();
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
        {
            if (mVideoFragment != null)
            {
                mVideoFragment.toggleFullScreen(false);
            }
        }
        else
        {
            if (mVideoFragment != null)
            {
                mVideoFragment.toggleFullScreen(true);
            }
        }
    }

    @Override public void onResume()
    {
        super.onResume();
        mVideoPlayerController.initWindowParameters();
        ScreenUtils.hideNavigationAndStatusBar(getActivity().getWindow());
        playVideo(mCurrentVideoID);
        mVideoPlayerController.setKidAvatar(mKidAvatarURL);
        mVideoPlayerController.setVideoName(mVideoName);
        mVideoPlayerController.setRelatedContentItemListener(mRelatedContentListener);
        mVideoPlayerController.setVideoPlayerListener(mVideoPlayerListener);
        mVideoPlayerController.setNumberOfLikes(mNumberOfLikes);
        mVideoPlayerController.setLikeIndication(mIsLiked);
    }

    @Override public void onPause()
    {
        super.onPause();
        mVideoPlayerContainerFrameLayout.setVisibility(View.INVISIBLE);
        mVideoPlayerController.closeView();
    }

    @Override public void onDestroy()
    {
        super.onDestroy();
        mVideoFragment.onDestroy();
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener)
    {
        mVideoPlayerListener = videoPlayerListener;
    }

    public void setVideoID(String videoID)
    {
        mCurrentVideoID = videoID;
        if (mVideoFragment != null)
        {
            mVideoFragment.setVideoId(mCurrentVideoID);
        }
    }

    public void playVideo(String videoID)
    {
        mCurrentVideoID = videoID;
        if (mVideoFragment != null)
        {
            mVideoFragment.setVideoId(mCurrentVideoID);
            mVideoFragment.playVideo();
        }
    }

    public void resumeVideoIfUserDidNotPauseIt()
    {
        if (mVideoFragment != null && mVideoPlayerController.getIsUserPausedVideo() == false)
        {
            mVideoFragment.setVideoId(mCurrentVideoID);
            mVideoFragment.playVideo();
        }
    }

    public void stopVideo()
    {
        if (mVideoFragment != null)
        {
            mVideoFragment.pauseVideo();
        }
    }

    public void setTopBarTitle(String topBarTitle)
    {

    }

    public void setNumberOfLikes(String numberOfLikes)
    {
        mNumberOfLikes = numberOfLikes;
        if (mVideoPlayerController != null)
        {
            mVideoPlayerController.setNumberOfLikes(mNumberOfLikes);
        }
    }

    public void setLikeIndication(boolean isLiked)
    {
        mIsLiked = isLiked;
        if (mVideoPlayerController != null)
        {
            mVideoPlayerController.setLikeIndication(mIsLiked);
        }
    }

    public void setKidAvatarImage(String avatarURL)
    {
        mKidAvatarURL = avatarURL;
    }

    public void setVideoName(String videoName)
    {
        mVideoName = videoName;
        if (mVideoPlayerController != null)
        {
            mVideoPlayerController.setVideoName(mVideoName);
        }
    }

    public void setRelatedContentItemListener(ContentPanelView.IOnContentItemClickListener itemListener)
    {
        mRelatedContentListener = itemListener;
    }

    public void setRelatedContent(ArrayList<ContentItem> content)
    {
        mVideoPlayerController.setRelatedContent(content);
    }
}
