package com.kidoz.sdk.api.players.video_player.ui.fragments;

import android.os.Bundle;

import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;



/**
 * Created by roni on 7/6/2015.
 */
public class VideoFragment extends YouTubePlayerSupportFragment implements YouTubePlayer.OnInitializedListener
{
    public static String TAG = VideoFragment.class.getSimpleName();
    private static final String YOU_TUBE_DEVELOPER_ID = "AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc";

    private YouTubePlayer mYouTubePlayer;
    private String mVideoID;
    private VideoPlayerListener mVideoPlayerListener;
    private YouTubePlayer.PlaybackEventListener mPlaybackEventListener;
    private YouTubePlayer.OnFullscreenListener mOnFullscreenListener;

    public static VideoFragment newInstance()
    {
        return new VideoFragment();
    }

    @Override public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        initialize(YOU_TUBE_DEVELOPER_ID, this);
    }

    @Override public void onDestroy()
    {
        try
        {
            if (mYouTubePlayer != null)
            {
                mYouTubePlayer.release();
                mYouTubePlayer = null;
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to onDestroy: " + ex.getMessage());
        }
        super.onDestroy();
    }

    public void setVideoId(String videoId)
    {
        try
        {
            if (videoId != null && videoId.equals(mVideoID) == false)
            {
                mVideoID = videoId;
                if (mYouTubePlayer != null)
                {
                    mYouTubePlayer.loadVideo(videoId);
                }
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to set video ID: " + ex.getMessage());
        }
    }

    public void refreshVideo()
    {
        if (mVideoID != null)
        {
            try
            {
                if (mYouTubePlayer != null)
                {
                    mYouTubePlayer.release();
                    mYouTubePlayer = null;
                }
                initialize(YOU_TUBE_DEVELOPER_ID, this);
            }
            catch (Exception ex)
            {
                SDKLogger.printErrorLog(TAG, "Error when trying to refreshVideo: " + ex.getMessage());
            }
        }
    }

    public void playVideo()
    {
        try
        {
            if (mYouTubePlayer != null && mYouTubePlayer.isPlaying() == false && mVideoID != null)
            {
                mYouTubePlayer.play();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to playVideo: " + ex.getMessage());
        }
    }

    public void pauseVideo()
    {
        try
        {
            if (mYouTubePlayer != null)
            {
                mYouTubePlayer.pause();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to pauseVideo: " + ex.getMessage());
        }
    }

    @Override public void onPause()
    {
        super.onPause();
        try
        {
            if (mYouTubePlayer != null)
            {
                mYouTubePlayer.pause();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to onPause: " + ex.getMessage());
        }
    }

    @Override public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored)
    {
        try
        {
            mYouTubePlayer = youTubePlayer;
            initYouTubePlayer();
            if (restored == false && mVideoID != null)
            {
                mYouTubePlayer.loadVideo(mVideoID);
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to onInitializationSuccess: " + ex.getMessage());
        }
    }

    @Override public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result)
    {
        try
        {
            mYouTubePlayer = null;
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to onInitializationFailure: " + ex.getMessage());
        }
    }

    private void initYouTubePlayer()
    {
        try
        {
            mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.CHROMELESS);
            mYouTubePlayer.setPlayerStateChangeListener(new YouTubePlayer.PlayerStateChangeListener()
            {
                @Override public void onLoading()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onLoading();
                    }
                }

                @Override public void onLoaded(String s)
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onFinishedLoading();
                    }
                }

                @Override public void onAdStarted()
                {
                    if (mVideoPlayerListener != null)
                    {
                    }
                }

                @Override public void onVideoStarted()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onVideoStarted();
                    }
                }

                @Override public void onVideoEnded()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onVideoEnded();
                    }
                }

                @Override public void onError(YouTubePlayer.ErrorReason errorReason)
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onError(errorReason.toString());
                    }
                }
            });

            mYouTubePlayer.setPlaybackEventListener(new YouTubePlayer.PlaybackEventListener()
            {
                @Override public void onPlaying()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onPlaying();
                    }
                    if (mPlaybackEventListener != null)
                    {
                        mPlaybackEventListener.onPlaying();
                    }
                }

                @Override public void onPaused()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onPaused();
                    }
                    if (mPlaybackEventListener != null)
                    {
                        mPlaybackEventListener.onPaused();
                    }
                }

                @Override public void onStopped()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onStopped();
                    }
                    if (mPlaybackEventListener != null)
                    {
                        mPlaybackEventListener.onStopped();
                    }
                }

                @Override public void onBuffering(boolean b)
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onBuffering(b);
                    }
                }

                @Override public void onSeekTo(int i)
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onSeekTo(i);
                    }
                }
            });

            mYouTubePlayer.setPlaylistEventListener(new YouTubePlayer.PlaylistEventListener()
            {
                @Override public void onPrevious()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onPrevious();
                    }
                }

                @Override public void onNext()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onNext();
                    }
                }

                @Override public void onPlaylistEnded()
                {
                    if (mVideoPlayerListener != null)
                    {
                        mVideoPlayerListener.onPlaylistEnded();
                    }
                }
            });

            mYouTubePlayer.addFullscreenControlFlag(YouTubePlayer.FULLSCREEN_FLAG_CUSTOM_LAYOUT);
            mYouTubePlayer.setOnFullscreenListener(mOnFullscreenListener);
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to initYouTubePlayer: " + ex.getMessage());
        }
    }

    public void toggleFullScreen(boolean isOpenInFullScreen)
    {
        try
        {
            if (mYouTubePlayer != null)
            {
                mYouTubePlayer.setFullscreen(isOpenInFullScreen);
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to toggleFullScreen: " + ex.getMessage());
        }
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener)
    {
        mVideoPlayerListener = videoPlayerListener;
    }

    public void setOnFullscreenListener(YouTubePlayer.OnFullscreenListener onFullscreenListener)
    {
        mOnFullscreenListener = onFullscreenListener;
    }

    public void setWrapperPlaybackEventListener(YouTubePlayer.PlaybackEventListener playbackEventListener)
    {
        mPlaybackEventListener = playbackEventListener;
    }

    public boolean getIsPlaying()
    {
        boolean result = false;
        try
        {
            if (mYouTubePlayer != null)
            {
                result = mYouTubePlayer.isPlaying();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to getIsPlaying: " + ex.getMessage());
        }
        return result;
    }

    public void seekVideo(int progressMilliseconds)
    {
        try
        {
            if (mYouTubePlayer != null)
            {
                mYouTubePlayer.seekToMillis(progressMilliseconds);
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to seekVideo: " + ex.getMessage());
        }
    }

    public long getVideoCurrentTime()
    {
        long result = 0;
        try
        {
            if (mYouTubePlayer != null)
            {
                result = mYouTubePlayer.getCurrentTimeMillis();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to getVideoCurrentTime: " + ex.getMessage());
        }
        return result;
    }

    public long getVideoTotalTime()
    {
        long result = 0;
        try
        {
            if (mYouTubePlayer != null)
            {
                result = mYouTubePlayer.getDurationMillis();
            }
        }
        catch (Exception ex)
        {
            SDKLogger.printErrorLog(TAG, "Error when trying to getVideoTotalTime: " + ex.getMessage());
        }
        return result;
    }

}
