package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.kidoz.sdk.api.R;


/**
 * Created by roni on 7/19/2015.
 */
public class RotateVideoButton extends ImageView
{
    private boolean mIsOpenInFullScreen;

    public RotateVideoButton(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
        if(isInEditMode()==true)
        {
            setImageResource(R.drawable.rotate_to_portrait);
        }
    }

    private void initView()
    {
        refreshRotateOnClickStatus();
    }

    public void refreshRotateOnClickStatus()
    {
        if (getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
        {
            setImageResource(R.drawable.rotate_to_landscape);
            mIsOpenInFullScreen = true;
        }
        else
        {
            setImageResource(R.drawable.rotate_to_portrait);
            mIsOpenInFullScreen = false;
        }
    }

    public boolean getIsOpenInFullScreen()
    {
        return mIsOpenInFullScreen;
    }
}
