package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.FontUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.ItemVerticalRecycleViewAdapter;
import com.squareup.imagelib.Picasso;

import java.util.ArrayList;


/**
 * Created by roni on 7/8/2015.
 */
public class RelatedContentPortraitContainer extends RelativeLayout
{
    private View mRootView;
    private TextView mVideoNameTextView;
    private TextView mRelatedContentLabelTextView;
    private ImageView mKidAvatarSimpleDraweeView;
    private LinearLayout mkidDetailsContainerLayout;
    private LinearLayout mVideoNameContainerLayout;
    private RecyclerView mRecyclerView;
    private GridLayoutManager mLayoutManager;
    private ItemVerticalRecycleViewAdapter mAdapter;
    private int mkidDetailsContainerLayoutHeight;
    private int mVideoNameContainerLayoutHeight;
    private int mPadding;
    private int itemOuterMargin;

    public RelatedContentPortraitContainer(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        mRootView = inflate(getContext(), R.layout.related_content_portrait, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        mRootView.setLayoutParams(params);
        addView(mRootView);

        mVideoNameTextView = (TextView) mRootView.findViewById(R.id.videoNameTextView);
        mVideoNameTextView.setTypeface(FontUtils.getFont(getContext(), FontUtils.FONT_TYPE.DOSIS_BOLD.getValue()));
        mRelatedContentLabelTextView = (TextView) mRootView.findViewById(R.id.RelatedLabelTextView);
        mRelatedContentLabelTextView.setTypeface(FontUtils.getFont(getContext(), FontUtils.FONT_TYPE.DOSIS_BOLD.getValue()));
        mKidAvatarSimpleDraweeView = (ImageView) mRootView.findViewById(R.id.kidAvatarSimpleDraweeView);
        mkidDetailsContainerLayout = (LinearLayout) mRootView.findViewById(R.id.kidDetailsContainerLayout);
        mVideoNameContainerLayout = (LinearLayout) mRootView.findViewById(R.id.videoNameContainerLayout);
        initRecyclerView();
    }

    private void initRecyclerView()
    {
        mRecyclerView = (RecyclerView) mRootView.findViewById(R.id.RelatedContentRecyclerViewPortrait);
        mRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener()
        {
            @SuppressWarnings("deprecation") @Override public void onGlobalLayout()
            {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN)
                {
                    mRootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                }
                else
                {
                    mRootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                }
                int widthMeasureSpec = MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.MATCH_PARENT, MeasureSpec.UNSPECIFIED);
                int heightMeasureSpec = MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.WRAP_CONTENT, MeasureSpec.UNSPECIFIED);
                mVideoNameContainerLayout.measure(widthMeasureSpec, heightMeasureSpec);
                mkidDetailsContainerLayout.measure(widthMeasureSpec, heightMeasureSpec);
                mPadding = getResources().getDimensionPixelSize(R.dimen.VideoPlayerFragmentRelatedContentRecyclerViewPortraitPadding);
                mVideoNameContainerLayoutHeight = mVideoNameContainerLayout.getMeasuredHeight();
                mkidDetailsContainerLayoutHeight = mkidDetailsContainerLayout.getMeasuredHeight();

                int recyclerViewTopPadding = mkidDetailsContainerLayoutHeight + mVideoNameContainerLayoutHeight;
                mRecyclerView.setPadding(mPadding, recyclerViewTopPadding, mPadding, mPadding);
            }
        });

        mLayoutManager = new GridLayoutManager(getContext(), 2);
        mRecyclerView.setLayoutManager(mLayoutManager);
        mRecyclerView.setHasFixedSize(true);
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mAdapter = new ItemVerticalRecycleViewAdapter(getContext(),2);
        mAdapter.setFixedItemRatio(0.5f);
        itemOuterMargin = mAdapter.getItemOuterMargin();
        mRecyclerView.setAdapter(mAdapter);

        mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener()
        {
            @Override public void onScrolled(RecyclerView recyclerView, int dx, int dy)
            {
                super.onScrolled(recyclerView, dx, dy);
                scrollRelatedContent();
            }

            @Override public void onScrollStateChanged(RecyclerView recyclerView, int newState)
            {
                super.onScrollStateChanged(recyclerView, newState);
            }
        });

        mRecyclerView.scrollToPosition(0);
        mkidDetailsContainerLayout.setTranslationY(0);
        mVideoNameContainerLayout.setTranslationY(0);
    }


    private void scrollRelatedContent()
    {
        if (mAdapter.getItemCount() > 0)
        {
            View firstChild = mRecyclerView.getChildAt(0);
            if (firstChild != null)
            {
                int firstChildTop = mVideoNameContainerLayoutHeight + mkidDetailsContainerLayoutHeight + mPadding - firstChild.getTop() + itemOuterMargin;
                int firstVisiblePosition = mLayoutManager.findFirstVisibleItemPosition();
                if (firstVisiblePosition >= 0)
                {
                    if (firstChildTop >= 0 && firstChildTop <= (mVideoNameContainerLayoutHeight + mkidDetailsContainerLayoutHeight))
                    {
                        mVideoNameContainerLayout.setVisibility(View.VISIBLE);
                        mkidDetailsContainerLayout.setVisibility(View.VISIBLE);

                        if (firstChildTop <= mkidDetailsContainerLayoutHeight + mVideoNameContainerLayoutHeight / 2)
                        {
                            mVideoNameContainerLayout.setTranslationY((int) (-firstChildTop * 0.5f));
                        }
                        else
                        {
                            mVideoNameContainerLayout.setTranslationY(-firstChildTop);
                        }
                        mkidDetailsContainerLayout.setTranslationY(-firstChildTop);
                    }
                    else
                    {
                        mVideoNameContainerLayout.setVisibility(View.INVISIBLE);
                        mkidDetailsContainerLayout.setVisibility(View.INVISIBLE);
                    }
                }
            }
        }
    }

    public void setContent(final ArrayList<ContentItem> content)
    {
        if (mAdapter != null)
        {
            mAdapter.setContentData(content,false);
            mRecyclerView.scrollToPosition(0);
            mkidDetailsContainerLayout.setTranslationY(0);
            mVideoNameContainerLayout.setTranslationY(0);
            scrollRelatedContent();
            new Handler().postDelayed(new Runnable()
            {
                @Override public void run()
                {
                    mRecyclerView.scrollToPosition(0);
                    mkidDetailsContainerLayout.setTranslationY(0);
                    mVideoNameContainerLayout.setTranslationY(0);
                    scrollRelatedContent();
                }
            }, 300);
        }
    }

    public void setKidAvatarURL(String avatarURL)
    {
//        Postprocessor maskPostProcessor = new BasePostprocessor()
//        {
//            @Override public String getName()
//            {
//                return "MaskProcessor";
//            }
//
//            @Override public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory)
//            {
//                Bitmap maskedBitmap = ImageUtil.getMaskedBitmap(getContext(), sourceBitmap, R.drawable.avatar_bubble_mask);
//                CloseableReference<Bitmap> bitmapRef = bitmapFactory.createBitmap(maskedBitmap.getWidth(), maskedBitmap.getHeight());
//                try
//                {
//                    Bitmap destBitmap = bitmapRef.get();
//                    for (int x = 0; x < destBitmap.getWidth(); x++)
//                    {
//                        for (int y = 0; y < destBitmap.getHeight(); y++)
//                        {
//                            destBitmap.setPixel(x, y, maskedBitmap.getPixel(x, y));
//                        }
//                    }
//                    return CloseableReference.cloneOrNull(bitmapRef);
//                }
//                finally
//                {
//                    CloseableReference.closeSafely(bitmapRef);
//                }
//            }
//        };
        int widthMeasureSpec = MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.MATCH_PARENT, MeasureSpec.UNSPECIFIED);
        int heightMeasureSpec = MeasureSpec.makeMeasureSpec(ViewGroup.LayoutParams.MATCH_PARENT, MeasureSpec.UNSPECIFIED);
        mKidAvatarSimpleDraweeView.measure(widthMeasureSpec, heightMeasureSpec);
        Picasso.with(getContext()).load(avatarURL).into(mKidAvatarSimpleDraweeView);

    }

    public void setVideoName(String videoName)
    {
        mVideoNameTextView.setText("");
        if (videoName != null)
        {
            if (videoName.startsWith("null") == true)
            {
                videoName = videoName.replace("null", "");
            }
            mVideoNameTextView.setText(videoName);
        }
    }

    public void setRelatedContentListener(ContentPanelView.IOnContentItemClickListener contentListener)
    {
        mAdapter.setOnItemClickListener(contentListener);
    }

    public void refresh()
    {
        mAdapter.notifyDataSetChanged();
    }

    public boolean getIsRelatedLoaded()
    {
        return mAdapter.getItemCount() > 0 ? true : false;
    }


    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        mAdapter.setSpanCount(2,newConfig.orientation);
        mLayoutManager = new GridLayoutManager(getContext(), 2);
        mRecyclerView.setLayoutManager(mLayoutManager);
    }
}
