package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Handler;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.adapters.RelatedContentAdapter;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.ContentPanelView;
import com.kidoz.sdk.api.ui_views.ItemHorizontalRecycleViewAdapter;

import java.util.ArrayList;



/**
 * Created by roni on 7/13/2015.
 */
public class RelatedContentLandscapeContainer extends RelativeLayout
{
    private View mRootView;
    private RelativeLayout mRecyclerViewContainer;
    private TextView mRelatedContentLabelTextView;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private ItemHorizontalRecycleViewAdapter mAdapter;
    private Handler mHandler;
    private int mTranslateDistance;
    private RelatedContentLandscapeContainerListener mRelatedContentLandscapeContainerListener;

    public RelatedContentLandscapeContainer(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        mHandler = new Handler();
        mRootView = inflate(getContext(), R.layout.related_content_landscape, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        mRootView.setLayoutParams(params);
        addView(mRootView);
        mRelatedContentLabelTextView = (TextView) mRootView.findViewById(R.id.LandscapeRelatedLabelTextView);
        initRecyclerView();
    }

    private void initRecyclerView()
    {
        int numberOfItemsInARow;
        float itemRatio;
        if (ScreenUtils.getIsTablet(getContext()) == true)
        {
            numberOfItemsInARow = RelatedContentAdapter.ROWS_COUNT_TABLET_LANDSCAPE;
            itemRatio = RelatedContentAdapter.ITEM_RATIO_TABLET_LANDSCAPE;
        }
        else
        {
            numberOfItemsInARow = RelatedContentAdapter.ROWS_COUNT_PHONE_LANDSCAPE;
            itemRatio = RelatedContentAdapter.ITEM_RATIO_PHONE_LANDSCAPE;
        }

        int screenWidth = Math.min(ScreenUtils.getScreenSize(getContext(), true), ScreenUtils.getScreenSize(getContext(), false));
        int itemWidth = screenWidth / numberOfItemsInARow;
        int itemHeight = (int) (itemWidth * itemRatio);
        int padding = getResources().getDimensionPixelSize(R.dimen.VideoPlayerFragmentRelatedContentRecyclerViewPortraitPadding);
        int layoutMargin = getResources().getDimensionPixelSize(R.dimen.RelatedItemCardMargin);
        int containerHeight = itemHeight + (layoutMargin * 2) + (padding * 2);

        mRecyclerViewContainer = (RelativeLayout) mRootView.findViewById(R.id.RecyclerViewContainer);
        mRecyclerViewContainer.getLayoutParams().height = containerHeight;

        mRecyclerView = (RecyclerView) mRootView.findViewById(R.id.RelatedContentRecyclerViewLandscape);
        mRecyclerView.setPadding(padding, padding, padding, 0);
        mLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mRecyclerView.setLayoutManager(mLayoutManager);
        mRecyclerView.setHasFixedSize(true);
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mAdapter = new ItemHorizontalRecycleViewAdapter(getContext(),itemHeight);
        mRecyclerView.setAdapter(mAdapter);

        mRecyclerView.setOnTouchListener(new OnTouchListener()
        {
            @Override
            public boolean onTouch(View v, MotionEvent event)
            {
                if (mRelatedContentLandscapeContainerListener != null)
                {
                    mRelatedContentLandscapeContainerListener.onInterceptTouchRequest();
                }
                return false;
            }
        });
    }

    public void setContent(final ArrayList<ContentItem> content)
    {
        if (mAdapter != null)
        {
            mAdapter.setContentData(content, false);
        }
    }

    public void setRelatedContentListener(ContentPanelView.IOnContentItemClickListener contentListener)
    {
        mAdapter.setOnItemClickListener(contentListener);
    }

    public void animateEnter()
    {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE && mRecyclerView.getChildCount() > 0)
        {
            AnimationsUtils.animateRelatedContainerLandscapeSlideIn(this);
            if (mRelatedContentLandscapeContainerListener != null)
            {
                mRelatedContentLandscapeContainerListener.onRelatedPanelStateChanged(true);
            }
        }
    }

    public void animateExit()
    {
        if (getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE)
        {
            AnimationsUtils.animateRelatedContainerLandscapeSlideOut(this, mTranslateDistance);
            if (mRelatedContentLandscapeContainerListener != null)
            {
                mRelatedContentLandscapeContainerListener.onRelatedPanelStateChanged(false);
            }
        }
    }

    public void refresh()
    {
        mAdapter.notifyDataSetChanged();
    }

    public boolean getIsRelatedLoaded()
    {
        return mAdapter.getItemCount() > 0 ? true : false;
    }

    public void setTranslateDistance(int translateDistance)
    {
        mTranslateDistance = translateDistance;
    }

    public void setRelatedContentLandscapeContainerListener(RelatedContentLandscapeContainerListener relatedContentLandscapeContainerListener)
    {
        mRelatedContentLandscapeContainerListener = relatedContentLandscapeContainerListener;
    }

    public interface RelatedContentLandscapeContainerListener
    {
        public void onInterceptTouchRequest();

        public void onRelatedPanelStateChanged(boolean isOpened);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        mLayoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false);
        mRecyclerView.setLayoutManager(mLayoutManager);
    }
}
