package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;


/**
 * Created by roni on 7/9/2015.
 */
public class PlayAndPauseButton extends RelativeLayout
{
    private ImageView mIconImageView;
    private Handler mHandler;
    private InterceptTouchEventListener mInterceptTouchEventListener;
    private PLAY_AND_PAUSE_STATUS mPlayerStatus;

    public PlayAndPauseButton(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        setBackgroundResource(R.drawable.youtube_refresh_video_icon);
        mHandler = new Handler();
        mIconImageView = new ImageView(getContext());
        mIconImageView.setImageResource(R.drawable.animateable_refresh_icon);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        addView(mIconImageView, params);
    }

    public void setStatus(PLAY_AND_PAUSE_STATUS status)
    {
        mIconImageView.clearAnimation();
        mPlayerStatus = status;
        switch (mPlayerStatus)
        {
            case LOADING:
            {
                setBackgroundResource(R.drawable.youtube_refresh_video_icon);
                mIconImageView.setImageResource(R.drawable.animateable_refresh_icon);
            }
            case ERROR:
            {
                break;
            }
            case PLAYING:
            {
                mHandler.postDelayed(new Runnable()
                {
                    @Override public void run()
                    {
                        setBackgroundResource(0);
                        mIconImageView.setImageResource(R.drawable.youtube_pause_video_icon);
                    }
                }, AnimationsUtils.EXIT_ANIMATION_TIME * 2);
                break;
            }
            case PAUSING:
            {
                setBackgroundResource(0);
                mIconImageView.setImageResource(R.drawable.youtube_play_video_icon);
                break;
            }
        }
    }

    public void animateLoading()
    {
        if (mPlayerStatus == PLAY_AND_PAUSE_STATUS.LOADING)
        {
            AnimationsUtils.animateRotate(mIconImageView);
        }
    }

    public PLAY_AND_PAUSE_STATUS getPlayAndPauseStatus()
    {
        return mPlayerStatus;
    }

    public void animateEnter()
    {
        AnimationsUtils.animateFade(this, true,1500, null);
    }

    public void animateExit()
    {
        if (mPlayerStatus != PLAY_AND_PAUSE_STATUS.ERROR)
        {
            AnimationsUtils.animateFade(this, false, 1500,null);
        }
    }

    public void setInterceptTouchEventListener(InterceptTouchEventListener interceptTouchEventListener)
    {
        mInterceptTouchEventListener = interceptTouchEventListener;
    }

    public interface InterceptTouchEventListener
    {
        public void setIsCanInterceptTouchEvent(boolean isCanInterceptTouchEvent);
    }

    public enum PLAY_AND_PAUSE_STATUS
    {
        PLAYING, PAUSING, ERROR, LOADING
    }

}
