package com.kidoz.sdk.api.players.video_player.infra_structure;

import android.graphics.Color;

import java.util.ArrayList;

/**
 * Created by roni on 7/8/2015.
 */
public class BaseContentItem
{
    private String mThumbnailURL;
    private String mDescription;
    private int mBackgroundColor;
    private int mDescriptionColor;
    private int mIconResourceID;

    public BaseContentItem()
    {
        mBackgroundColor = Color.WHITE;
        mDescriptionColor = Color.BLACK;
    }


    public String getThumbnailURL()
    {
        return mThumbnailURL;
    }

    public void setThumbnailURL(String thumbnailURL)
    {
        mThumbnailURL = thumbnailURL;
    }

    public String getDescription()
    {
        return mDescription;
    }

    public void setDescription(String description)
    {
        mDescription = description;
    }

    public int getBackgroundColor()
    {
        return mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor)
    {
        mBackgroundColor = backgroundColor;
    }

    public int getDescriptionColor()
    {
        return mDescriptionColor;
    }

    public void setDescriptionColor(int descriptionColor)
    {
        mDescriptionColor = descriptionColor;
    }

    public int getIconResourceID()
    {
        return mIconResourceID;
    }

    public void setIconResourceID(int iconResourceID)
    {
        mIconResourceID = iconResourceID;
    }

    public static ArrayList<BaseContentItem> createTestArrayList()
    {
        String[] thumbnails = new String[]{
                "http://i.imgur.com/sHuMn8Eb.jpg",
                "http://i.imgur.com/IO6NJMub.jpg",
                "http://i.imgur.com/NyV7aK0b.jpg",
                "http://i.imgur.com/iifuiBob.jpg",
                "http://i.imgur.com/wDhbVxrb.jpg",
                "http://i.imgur.com/fF0elmAb.jpg",
                "http://i.imgur.com/VHuyXj4b.jpg",
                "http://i.imgur.com/AAwJl96b.jpg",
                "http://i.imgur.com/VyMktuHb.jpg",
                "http://i.imgur.com/EqxkgdRb.jpg",
                "http://i.imgur.com/IAG9W5Sb.jpg",
                "http://i.imgur.com/xCo78Ifb.jpg"};
        ArrayList<BaseContentItem> result = new ArrayList<BaseContentItem>();

        for (int itemIndex = 0; itemIndex < thumbnails.length; itemIndex++)
        {
            BaseContentItem nextBaseContentItem = new BaseContentItem();
            nextBaseContentItem.setThumbnailURL(thumbnails[itemIndex]);
            nextBaseContentItem.setDescription(thumbnails[itemIndex]);
            result.add(nextBaseContentItem);
        }
        return result;
    }
}
