package com.kidoz.sdk.api.general.utils;

import android.content.ContentValues;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import java.util.Iterator;
import java.util.Set;

public class SDKLogger
{

    public static final String GENERAL_TAG = "[:Kidoz SDK:]";
    public static boolean IS_DEBBUG_MODE = true;

    public static final void printInfoLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.i(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printInfoLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.i(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printWarningLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.w(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printWarningLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.w(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printErrorLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.e(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printErrorLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.e(tag, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printDebbugLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.d(GENERAL_TAG, "[KIDOZ SDK] : " + msg);
        }
    }

    public static final void printDebugToast(Context context, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
        }

    }

    public static final void printDebbugLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.d(tag, msg);
        }
    }

    public static final void printGetRequestDebugLog(String url, ContentValues contentValues, String requestType)
    {
        if (IS_DEBBUG_MODE)
        {
            if (contentValues != null)
            {
                StringBuilder sb = new StringBuilder("|\n|\n|\n");
                sb.append("| \n<<<<< |KIDOZ SDK| **[REQUEST]** API : [GET] , RequestType :  [" + requestType + "] >>>>>\n\n");
                sb.append("[WEBSITE_URL] :" + url + "\n");
                sb.append("[PARAMETERS] : \n");

                Set<String> set = contentValues.keySet();
                if (set.size() > 0)
                {
                    Iterator<String> iter = set.iterator();
                    while (iter.hasNext())
                    {
                        String key = iter.next();
                        sb.append("-- " + key + " = " + contentValues.getAsString(key));
                        sb.append("\n");
                    }
                }

                sb.append("\n|\n|\n|\n");
                Log.d(GENERAL_TAG, sb.toString());
            }
        }
    }

    public static final void printPostRequestDebugLog(String url, ContentValues contentValues, String requestType)
    {
        if (IS_DEBBUG_MODE)
        {
            if (contentValues != null)
            {
                StringBuilder sb = new StringBuilder("|\n|\n|\n");
                sb.append("\n<<<<< |KIDOZ SDK| **[REQUEST]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n");
                sb.append("[WEBSITE_URL] :" + url + "\n");
                sb.append("[PARAMETERS] : \n");

                Set<String> set = contentValues.keySet();
                if (set.size() > 0)
                {
                    Iterator<String> iter = set.iterator();
                    while (iter.hasNext())
                    {
                        String key = iter.next();
                        sb.append("-- " + key + " = " + contentValues.getAsString(key));
                        sb.append("\n");
                    }
                }
                sb.append("\n|\n|\n|\n");
                Log.d(GENERAL_TAG, sb.toString());
            }
        }
    }

    public static final void printResponce(String responce, String requestType)
    {
        if (IS_DEBBUG_MODE)
        {
            StringBuilder sb = new StringBuilder("|\n|\n|\n");
            sb.append(" \n\n<<<<< |KIDOZ SDK| **[RESPONCE]** API : [POST] , RequestType :  [" + requestType + "] >>>>>\n\n");
            sb.append("[RESPONCE STRING] : \n");
            sb.append(" " + responce);
            sb.append("|\n|\n|\n");
            Log.d(GENERAL_TAG, sb.toString());
        }
    }


    public static final void printToast(Context context, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
        }
    }

}
