package com.kidoz.sdk.api.general.custom_views;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.players.web_player.KidozWebView;

/**
 * Created by Eugine on 7/27/2015.
 */
public class KidozBottomBar extends LinearLayout
{
    public static final float BACKGROUND_RATIO = 118f / 1920f;
    public static final float KIDOZ_LOGO_RATIO = 136f / 105f;
    public static final float KIDOZ_LOGO_AND_BACKGROUND_RATIO = 200f / 118f;

    private RelativeLayout mRootView;
    private ImageView mBackgroundImageView;
    private Utils.StaticHandler mStaticHandler = new com.kidoz.sdk.api.general.utils.Utils.StaticHandler();
    private FrameLayout mAboutKidozContainer;
    private int[] mAboutKidozPivot;
    private boolean mIsOrientationPortrait;
    private KidozWebView mKidozWebView;
    private boolean mIsNeedToCloseWebViewOnClick = true;

    public KidozBottomBar(Context context)
    {
        super(context);
        initView();
    }

    public KidozBottomBar(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        initView();
    }

    private void initView()
    {
        mIsOrientationPortrait = getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT ? true : false;
        initRootView();
        initBackground();
        initAboutKidoz();
    }

    private void initAboutKidoz()
    {
        final ImageView KidozLogoImageView = (ImageView) mRootView.findViewById(R.id.KidozLogoImageView);
        KidozLogoImageView.getLayoutParams().height = (int) (mBackgroundImageView.getLayoutParams().height * KIDOZ_LOGO_AND_BACKGROUND_RATIO);
        KidozLogoImageView.getLayoutParams().width = (int) (KidozLogoImageView.getLayoutParams().height / KIDOZ_LOGO_RATIO);
        mAboutKidozPivot = new int[2];
        mAboutKidozPivot[0] = KidozLogoImageView.getLayoutParams().width / 2;
        mAboutKidozPivot[1] = KidozLogoImageView.getLayoutParams().height;

        mKidozWebView = (KidozWebView) mRootView.findViewById(R.id.AboutKidozWebView);
        mKidozWebView.getSettings().setUseWideViewPort(true);
        mKidozWebView.getSettings().setLoadWithOverviewMode(true);
        mKidozWebView.getSettings().setSupportZoom(false);
        mKidozWebView.setWebViewClient(new WebViewClient()
        {
            @Override public boolean shouldOverrideUrlLoading(WebView view, String url)
            {
                mIsNeedToCloseWebViewOnClick = false;
                if (url.startsWith("mailto:"))
                {
                    Intent mailIntent = new Intent(Intent.ACTION_SENDTO, Uri.parse(url));
                    getContext().startActivity(mailIntent);
                }
                else
                {
                    view.loadUrl(url);
                }
                return true;
            }
        });
        mKidozWebView.setOnTouchListener(new View.OnTouchListener()
        {
            @Override public boolean onTouch(View v, MotionEvent event)
            {
                boolean result = false;
                if (event.getAction() == MotionEvent.ACTION_UP)
                {
                    mRootView.postDelayed(new Runnable()
                    {
                        @Override public void run()
                        {
                            if (mIsNeedToCloseWebViewOnClick == true && mAboutKidozContainer.getVisibility() == View.VISIBLE)
                            {
                                hideAboutView();
                            }
                            mIsNeedToCloseWebViewOnClick = true;
                        }
                    }, 150);
                }
                else
                {
                    if (event.getAction() == MotionEvent.ACTION_MOVE)
                    {
                        mIsNeedToCloseWebViewOnClick = false;
                    }
                    if (mIsOrientationPortrait == true)
                    {
                        result = (event.getAction() == MotionEvent.ACTION_MOVE);
                    }
                }
                return result;
            }
        });
        mKidozWebView.setLongClickable(true);
        mKidozWebView.setOnLongClickListener(new OnLongClickListener()
        {
            @Override public boolean onLongClick(View v)
            {
                return true;
            }
        });
        mKidozWebView.loadUrl("http://kidoz.net/v3policy/");

        mAboutKidozContainer = (FrameLayout) mRootView.findViewById(R.id.AboutKidozContainer);
        mAboutKidozContainer.setVisibility(View.INVISIBLE);
        mRootView.findViewById(R.id.AboutKidozParentContainer).setOnTouchListener(new OnTouchListener()
        {
            @Override public boolean onTouch(View v, MotionEvent event)
            {
                boolean result = false;
                if (mAboutKidozContainer.getVisibility() == View.VISIBLE)
                {
                    hideAboutView();
                    result = true;
                }
                return result;
            }
        });

        mRootView.findViewById(R.id.KidozLogoImageView).setOnClickListener(new OnClickListener()
        {
            @Override public void onClick(View v)
            {
                mIsNeedToCloseWebViewOnClick = true;
                mAboutKidozContainer.setVisibility(View.VISIBLE);
                GenAnimator.playPopInFromRightBottom(mAboutKidozContainer, mAboutKidozPivot, new Animator.AnimatorListener()
                {
                    @Override public void onAnimationStart(Animator animation)
                    {
                        mAboutKidozContainer.setVisibility(View.VISIBLE);
                    }

                    @Override public void onAnimationEnd(Animator animation)
                    {

                    }

                    @Override public void onAnimationCancel(Animator animation)
                    {

                    }

                    @Override public void onAnimationRepeat(Animator animation)
                    {

                    }
                });
            }
        });



        mRootView.findViewById(R.id.ExitAboutKidozButtonImageView).setOnClickListener(new OnClickListener()
        {
            @Override public void onClick(View v)
            {
                GenAnimator.clickItemAnimation(v, 100, new GenAnimator.ViewAnimationListener()
                {
                    @Override public void onAnimationEnd()
                    {

                        hideAboutView();
                    }

                    @Override public void onAnimationStart()
                    {

                    }
                });
            }
        });
    }

    /** Hide about view */
    public void hideAboutView() {
        GenAnimator.playPopOutToRightBottom(mAboutKidozContainer, mAboutKidozPivot, new Animator.AnimatorListener()
        {
            @Override public void onAnimationStart(Animator animation)
            {
            }

            @Override public void onAnimationEnd(Animator animation)
            {
                mAboutKidozContainer.setVisibility(View.INVISIBLE);
                mKidozWebView.goBack();
            }

            @Override public void onAnimationCancel(Animator animation)
            {
                mAboutKidozContainer.setVisibility(View.INVISIBLE);
            }

            @Override public void onAnimationRepeat(Animator animation)
            {

            }
        });
    }

    /** Get is about view visible
     *
     * @return is visible
     * */
    public boolean isAboutViewVisible() {
       if(mAboutKidozContainer.getVisibility() == View.VISIBLE)  {
           return true;
       }else {
           return false;
       }
    }

    private void initRootView()
    {
        mRootView = (RelativeLayout) inflate(getContext(), R.layout.bottom_bar, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        addView(mRootView, params);
    }

    private void initBackground()
    {
        int screenMaxSize = Math.max(ScreenUtils.getScreenSize(getContext(), true), (ScreenUtils.getScreenSize(getContext(), false)));
        mBackgroundImageView = (ImageView) mRootView.findViewById(R.id.BottomBarBackground);
        mBackgroundImageView.getLayoutParams().width = screenMaxSize;
        mBackgroundImageView.getLayoutParams().height = (int) (screenMaxSize * BACKGROUND_RATIO);
    }

    public void setBottomBarBackgroundColor(int color)
    {
        //        if (mRootView != null)
        //        {
        //            mRootView.setBackgroundColor(color);
        //            invalidate();
        //        }
    }

    public void setImageUri(Uri imageUri)
    {
        //        if (mPowerByImageView != null)
        //        {
        //            mPowerByImageView.setImageURI(Utils.prepareCorrectUri(R.drawable.powered_by_kidoz));
        //        }
    }

    public void setBackgroundURI()
    {
        //        if (mViewBackground != null)
        //        {
        //            mViewBackground.setImageURI(Utils.prepareCorrectUri(R.drawable.bottom_bar_background));
        //        }
    }

    @Override protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();
    }

    @Override protected void onConfigurationChanged(Configuration newConfig)
    {
        super.onConfigurationChanged(newConfig);
        mIsOrientationPortrait = getContext().getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT ? true : false;
        mKidozWebView.scrollTo(0, 0);
    }
}
