package com.kidoz.sdk.api.analytics;



/**
 * This class help to create a timed event. This class got method for calculating the event duration in seconds for a given inner time parameters in milliseconds.
 * 
 * @author roni
 * 
 */
public class TimedEventParams
{
	private final String TAG = TimedEventParams.class.getSimpleName();
	private long mEventStartTimeInMilliseconds;
	private long mEventEndTimeInMilliseconds;
	private KidozEvent mKidozEvent;

	public long getEventStartTimeInMilliseconds()
	{
		return mEventStartTimeInMilliseconds;
	}

	public void setEventStartTimeInMilliseconds(long eventStartTimeInMilliseconds)
	{
		this.mEventStartTimeInMilliseconds = eventStartTimeInMilliseconds;
	}

	public long getEventEndTimeInMilliseconds()
	{
		return mEventEndTimeInMilliseconds;
	}

	public void setEventEndTimeInMilliseconds(long eventEndTimeInMilliseconds)
	{
		this.mEventEndTimeInMilliseconds = eventEndTimeInMilliseconds;
	}

	public KidozEvent getKidozEvent()
	{
		return mKidozEvent;
	}

	public void setKidozEvent(KidozEvent kidozEvent)
	{
		this.mKidozEvent = kidozEvent;
	}

	public void calculateAndAddEventDuration()
	{
		mKidozEvent.addParameterToJsonObject(LogParameters.DURATION, getDuration());
	}
	
	public String getDuration()
	{
		String result = null;
		mEventEndTimeInMilliseconds = System.currentTimeMillis();
		long eventDurationInSeconds = (mEventEndTimeInMilliseconds - mEventStartTimeInMilliseconds) / 1000;
		result = String.valueOf(eventDurationInSeconds);
		return result;
	}
}
