package com.kidoz.sdk.api.analytics;

import com.kidoz.sdk.api.general.utils.SDKLogger;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class KidozEvent
{
	private final String TAG = KidozEvent.class.getName();
	private SimpleDateFormat mSimpleDateFormat;
	private JSONObject mJsonObject;
	private String mRowID;

	public KidozEvent()
	{
		mJsonObject = new JSONObject();
		mSimpleDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss", Locale.getDefault());
		mSimpleDateFormat.setTimeZone(TimeZone.getDefault());
		String logTimeUTC = String.valueOf(System.currentTimeMillis());
		String logTimeLocal = mSimpleDateFormat.format(new Date(System.currentTimeMillis()));
		try
		{
			mJsonObject.put(LogParameters.LOG_TIME_UTC, logTimeUTC);
			mJsonObject.put(LogParameters.LOG_TIME_LOCAL, logTimeLocal);
		}
		catch (Exception ex)
		{
			SDKLogger.printErrorLog(TAG, "Error when tryin to add parameters to JsonObject: " + ex.getMessage());
		}

	}

	public void addParameterToJsonObject(String key, String value)
	{
		try
		{
			if (key != null && value != null)
			{
				mJsonObject.put(key, value);
			}
		}
		catch (Exception ex)
		{
			SDKLogger.printErrorLog(TAG, "Error when trying to add parameter to JsonObject: " + ex.getMessage());
		}
	}

	public void setJsonObject(JSONObject jsonObject)
	{
		mJsonObject = jsonObject;
	}

	public JSONObject getJSONObject()
	{
		return mJsonObject;
	}

	public void setRowID(String rowID)
	{
		mRowID = rowID;
	}

	public String getRowID()
	{
		return mRowID;
	}

	public void printData()
	{
		SDKLogger.printInfoLog(TAG, "*** KidozEvent ***");
		SDKLogger.printInfoLog(TAG, "Row ID = " + mRowID);
		SDKLogger.printInfoLog(TAG, "JsonObject= " + mJsonObject.toString());
	}
}
