package com.kidoz.sdk.api.analytics;


import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.ContentItem;

import org.json.JSONArray;

class ItemAnalyticsData
{
	private final String TAG = ItemAnalyticsData.class.getSimpleName();

	private ContentItem mContentItem;
	private int mTotlaNumberOfItems;
	private int mItemIndexInArray;
	private int mNumberOfItemsInPage;
	private int mColumnsNumber;
	private JSONArray mJSONArray;

	public ItemAnalyticsData()
	{
		mTotlaNumberOfItems = -1;
		mItemIndexInArray = -1;
		mNumberOfItemsInPage = -1;
		mColumnsNumber = -1;
	}

	public ContentItem getContentItem()
	{
		return mContentItem;
	}

	public void setContentItem(ContentItem contentItem)
	{
		mContentItem = contentItem;
	}

	public int getTotalNumberOfItems()
	{
		return mTotlaNumberOfItems;
	}

	public void setTotalNumberOfItems(int totlaNumberOfItems)
	{
		mTotlaNumberOfItems = totlaNumberOfItems;
	}

	public int getItemIndexInArray()
	{
		return mItemIndexInArray;
	}

	public void setItemIndexInArray(int itemIndexInArray)
	{
		mItemIndexInArray = itemIndexInArray;
	}

	public int getNumberOfVisibleItems()
	{
		return mNumberOfItemsInPage;
	}

	public void setNumberOfVisibleItems(int numberOfItemsInPage)
	{
		mNumberOfItemsInPage = numberOfItemsInPage;
	}

	public int getColumnsNumber()
	{
		return mColumnsNumber;
	}

	public void setColumnsNumber(int columnsNumber)
	{
		mColumnsNumber = columnsNumber;
	}

	public JSONArray geJSONArray()
	{
		return mJSONArray;
	}

	public void addValueToJSONArray(String value)
	{
		if (value != null)
		{
			if (mJSONArray == null)
			{
				mJSONArray = new JSONArray();
			}
			mJSONArray.put(value);
		}
	}

	public void printData()
	{
		SDKLogger.printDebbugLog(TAG, ">>>>ItemAnalyticsData Data:");
		SDKLogger.printDebbugLog(TAG, ">>>>ItemAnalyticsData ColumnsNumber:" + String.valueOf(mColumnsNumber));
		SDKLogger.printDebbugLog(TAG, ">>>>ItemAnalyticsData ItemIndexInArray:" + String.valueOf(mItemIndexInArray));
		SDKLogger.printDebbugLog(TAG, ">>>>ItemAnalyticsData NumberOfItemsInPage:" + String.valueOf(mNumberOfItemsInPage));
		SDKLogger.printDebbugLog(TAG, ">>>>ItemAnalyticsData JSONArray:" + mJSONArray.toString());
	}
}
