package com.kidoz.sdk.api;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.custom_views.AnimatableGifImageView;
import com.kidoz.sdk.api.general.utils.Utils;

/**
 * Created by Eugine on 8/26/2015.
 */
public class KidozButtonView extends RelativeLayout {

    private static final String TAG = KidozButtonView.class.getSimpleName();

    private static final float BUTTON_SIZE_AS_SCREEN_PORTION = 0.27f;
    private AnimatableGifImageView mAnimatableGifImageView;
    private InterstitialView mInterstitialView;

    private View mRootView;

    public KidozButtonView(Context context) {
        super(context);
        intiView();
    }

    public KidozButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        intiView();
    }

    public KidozButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        intiView();
    }

    /**
     * Initiate view
     */
    private void intiView() {

        mRootView = this;
        Point point = Utils.getScreenSize(getContext());
        int size = (int) (Math.min(point.x, point.y) * BUTTON_SIZE_AS_SCREEN_PORTION);

        Drawable drawable = ContextCompat.getDrawable(getContext(), R.drawable.more_btn_empty);
        int height = drawable.getMinimumHeight();
        int width = drawable.getMinimumWidth();
        float ratio = height / (float) width;

        mAnimatableGifImageView = new AnimatableGifImageView(getContext());

        RelativeLayout.LayoutParams animatableImageParams = new RelativeLayout.LayoutParams(size, (int) (size * ratio));
        addView(mAnimatableGifImageView, animatableImageParams);

       /* RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, (int) (size * ratio));
        setLayoutParams(params);*/

        mAnimatableGifImageView.setBackgroundResource(R.drawable.more_btn_logo);

        if (isInEditMode() == false) {

            mAnimatableGifImageView.setAnimatedGif(Utils.prepareCorrectUri("https://kidoz-cdn.s3.amazonaws.com/sdk/btn_animation.gif"), new AnimatableGifImageView.IOnAnimatedGifReadyListener() {
                @Override
                public void onGifReady() {
                    if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        mAnimatableGifImageView.setBackground(null);
                    }else {
                        mAnimatableGifImageView.setBackgroundDrawable(null);
                    }
                }
            });

            initInterstitialView();

            initClickListener();
        }
    }


    /**
     * Initiate button click listener
     */
    private void initClickListener() {
        setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mInterstitialView != null) {
                    GenAnimator.clickItemAnimation(mRootView, 100, new GenAnimator.ViewAnimationListener() {
                        @Override
                        public void onAnimationEnd() {
                            mInterstitialView.showView();
                        }

                        @Override
                        public void onAnimationStart() {

                        }
                    });
                }
            }
        });
    }

    /**
     * Initiate interstitial view
     */
    private void initInterstitialView() {
        if (getContext() instanceof FragmentActivity) {
            mInterstitialView = new InterstitialView.Builder(getContext(), ((FragmentActivity) getContext()).getSupportFragmentManager()).build();
        }
    }

    /**
     * Get the inner interstitial view object
     *
     * @return interstitial view object
     */
    public InterstitialView getInterstitialView() {
        return mInterstitialView;
    }
}
