package com.kidoz.events;

import android.app.IntentService;
import android.content.Intent;

import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.server_connect.ResultData;


public class SyncEventService extends IntentService
{
	public static final String TAG = SyncEventService.class.getSimpleName();

	public SyncEventService()
	{
		super("LogIntentService");
	}

	private static final int NUM_OF_RETRIES_IN_CASE_FAILED = 1;
	private static final int MAX_TIME_TO_ALLOW_SYNC_TO_RUN = 1000 * 60 * 15; // Safety mechanize to shutdown the sync thread if it runs too long ,witch means that something is wrong

//	private KidozAPIManager mKidozAPIManager;

	private Intent mIntent;
	private boolean mSyncRunning = false;
	private boolean mContinueSyncProcces;

	private int munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
	private long mServiceSyncStartTime;

	@Override
	protected void onHandleIntent(Intent intent)
	{
		EventLogger.printDebbugLog(TAG, ">>>> SyncEventService : onHandleIntent");
		if (intent != null && intent.hasExtra(EventManager.STOP_SERVICE_EXTRA))
		{
			mSyncRunning = false;
			mContinueSyncProcces = false;
		}

		if (mSyncRunning == false)
		{
//			mKidozAPIManager = new KidozAPIManager(this);
			EventLogger.printWarningLog(" ----------------------  ******************************  ----------------------");
			EventLogger.printWarningLog(" -----------------  START SYNCHRONIZATION OF LOG EVENTS DATA  V4.0 ----------------------");
			EventLogger.printWarningLog(" ----------------------  ******************************  ----------------------");

			mSyncRunning = true;
			mContinueSyncProcces = true;
			mServiceSyncStartTime = System.currentTimeMillis();
			EventLogger.printInfoLog("Log Events info:"+ mSyncRunning + " , " + mContinueSyncProcces);
			while (EventManager.getInstance().getIsCanSendLog(this) && isAllowedToRunTimeFrame() && mContinueSyncProcces)
			{
				EventLogger.printDebbugLog( ">>>> SyncEventService : sending logs");
				EventBulk bulk = EventManager.getInstance().getNextBulk(this);
				EventLogger.printInfoLog("Log Events Sync info : bulk value:" + bulk.toString());
				if (bulk != null)
				{
					String json = bulk.toString();
					if (json != null)
					{
						ResultData<Boolean> resultCallback =  KidozSDK.getApiManager(SyncEventService.this).sendKidozEventsToServerNotAsync(json);
						if (resultCallback != null && resultCallback.getResponseStatus().getIsSuccessful())
						{
							EventManager.getInstance().removeBulkFromDB(this, bulk);
							munOfRetriesInCaseFailedCount = NUM_OF_RETRIES_IN_CASE_FAILED;
						}
						else
						{
							if (munOfRetriesInCaseFailedCount > 0)
							{
								EventLogger.printInfoLog(TAG, "Log Events Sync Info : Server response failed ! Trying again...");
								munOfRetriesInCaseFailedCount--;
							}
							else
							{
								break;
							}
						}
					}
					else
					{
						EventLogger.printErrorLog(TAG, "Log Events Sync Error : Couldnt create JSON representation of an Events BULK !");
						break;
					}
				}
				else
				{
					EventLogger.printErrorLog(TAG, "Log Events Sync Error : Events BULK object is NULL !");
					break;
				}
			}
		}

		mSyncRunning = false;
		removeWakefullLock();
	}

	public boolean isAllowedToRunTimeFrame()
	{
		if ((System.currentTimeMillis() - mServiceSyncStartTime) < MAX_TIME_TO_ALLOW_SYNC_TO_RUN)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	public void removeWakefullLock()
	{
		if (mIntent != null)
		{
			try
			{
				SyncReciever.completeWakefulIntent(mIntent);
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
	}

	@Override
	public void onDestroy()
	{
		mContinueSyncProcces = false;
		super.onDestroy();
	}
}
