package com.kidoz.events;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

/**
 * Created by orikam on 8/24/15.
 */
public class EventLogger
{
    public static final String GENERAL_TAG = "[:Kidoz Events Logger:]";
    public static boolean IS_DEBBUG_MODE = false;//oooOri should be false

    public static final void printInfoLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.i(GENERAL_TAG, msg);
        }
    }

    public static final void printInfoLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.i(tag, msg);
        }
    }

    public static final void printWarningLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.w(GENERAL_TAG, msg);
        }
    }

    public static final void printWarningLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.w(tag, msg);
        }
    }

    public static final void printErrorLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.e(GENERAL_TAG, msg);
        }
    }

    public static final void printErrorLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.e(tag, msg);
        }
    }

    public static final void printDebbugLog(String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.d(GENERAL_TAG, msg);
        }
    }

    public static final void printDebugToast(Context context, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
        }

    }

    public static final void printDebbugLog(String tag, String msg)
    {
        if (IS_DEBBUG_MODE)
        {
            Log.d(tag, msg);
        }
    }
}//end EventLogger class
