package com.kidoz.events;


import com.kidoz.sdk.api.analytics.EventsBulk;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by orikam on 8/30/15.
 */
public class EventBulk
{
    private final String TAG = EventsBulk.class.getSimpleName();
    private final String KEY_DEVICE_PARAMS = "DeviceParams";
    private final String KEY_EVENT_PARAMS = "EventParams";
    private final String KEY_ENTRIES = "Entries";

    private JSONObject mDeviceParamsJSONObject;
    private ArrayList<Event> mEventArrayList;

    public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject)
    {
        mDeviceParamsJSONObject = deviceParamsJSONObject;
    }

    public JSONObject getDeviceParamsJSONObject()
    {
        return mDeviceParamsJSONObject;
    }

    public void setEventArrayList(ArrayList<Event> eventArrayList)
    {
        mEventArrayList = eventArrayList;
    }

    public ArrayList<Event> getEventArrayList()
    {
        return mEventArrayList;
    }

    /**
     * This method return a ready to be sent JSON. The result JSON contains the device params and all the events in a JSON array. The full JSON format can be found in KIDOZ V3 documentation.
     *
     * @return
     */
    private String convertToJson()
    {
        String result = null;
        if (mDeviceParamsJSONObject != null && mEventArrayList != null && mEventArrayList.size() > 0)
        {
            try
            {
                JSONObject jSONObject = new JSONObject();

                // 1. Insert device params.
                jSONObject.put(KEY_DEVICE_PARAMS, mDeviceParamsJSONObject);

                // 2. Insert log array.
                JSONArray jSONArray = new JSONArray();
                for (Event nextKidozEvent : mEventArrayList)
                {
                    JSONObject nextJsonObject = new JSONObject();
                    nextJsonObject.put(KEY_EVENT_PARAMS, nextKidozEvent.getJSONObject());
                    jSONArray.put(nextJsonObject);
                }
                jSONObject.put(KEY_ENTRIES, jSONArray);
                result = jSONObject.toString();
            }
            catch (Exception ex)
            {
                EventLogger.printErrorLog(TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public String toString()
    {
        return convertToJson();
    }
}
