package com.kidoz.events;

import java.math.BigInteger;
import java.security.MessageDigest;

public class EncoderUtils
{
    public static final String TAG = EncoderUtils.class.getSimpleName();

    private static final int BYTE_MSK = 0xFF;
    private static final int HEX_DIGIT_MASK = 0xF;
    private static final int HEX_DIGIT_BITS = 4;
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public static String encryptWithMD5(String text)
    {
        String result = null;
        if (text != null)
        {
            try
            {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                String stringToEncode = text;
                messageDigest.update(stringToEncode.getBytes());

                // Encrypting
                final byte[] resultBytes = messageDigest.digest();
                BigInteger number = new BigInteger(1, resultBytes);
                String encriptedResult = number.toString(16);
                // Padding to add the 0 omitted to the beginning of the string by
                // the BigInteger.
                // As MD5 have to be 32 bytes, if the BigInteger we got is less than
                // 32 bytes we know we need to add zeros
                while (encriptedResult.length() < 32)
                {
                    encriptedResult = "0" + encriptedResult;
                }
                result = encriptedResult;
            }
            catch (Exception ex)
            {
                EventLogger.printErrorLog("Can't create MD5: " + ex.getMessage());
            }
        }
        return result;
    }

}
