/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import java.io.IOException;
import pl.droidsonroids.gif.GifDrawable;

final class GifViewUtils {
    static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";

    private GifViewUtils() {
    }

    static InitResult initImageView(ImageView view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null && !view.isInEditMode()) {
            int sourceResId = GifViewUtils.getResourceId(view, attrs, true);
            int backgroundResId = GifViewUtils.getResourceId(view, attrs, false);
            boolean freezesAnimation = GifViewUtils.isFreezingAnimation((View)view, attrs, defStyleAttr, defStyleRes);
            return new InitResult(sourceResId, backgroundResId, freezesAnimation);
        }
        return new InitResult(0, 0, false);
    }

    private static int getResourceId(ImageView view, AttributeSet attrs, boolean isSrc) {
        String resourceTypeName;
        int resId = attrs.getAttributeResourceValue(ANDROID_NS, isSrc ? "src" : "background", 0);
        if (resId > 0 && ("drawable".equals(resourceTypeName = view.getResources().getResourceTypeName(resId)) || "raw".equals(resourceTypeName)) && !GifViewUtils.setResource(view, isSrc, resId)) {
            return resId;
        }
        return 0;
    }

    @TargetApi(value=16)
    static boolean setResource(ImageView view, boolean isSrc, int resId) {
        Resources res = view.getResources();
        if (res != null) {
            try {
                GifDrawable d = new GifDrawable(res, resId);
                if (isSrc) {
                    view.setImageDrawable((Drawable)d);
                } else if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground((Drawable)d);
                } else {
                    view.setBackgroundDrawable((Drawable)d);
                }
                return true;
            }
            catch (Resources.NotFoundException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean isFreezingAnimation(View view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        boolean freezesAnimation = false;
        return freezesAnimation;
    }

    static boolean setGifImageUri(ImageView imageView, Uri uri) {
        if (uri != null) {
            try {
                imageView.setImageDrawable((Drawable)new GifDrawable(imageView.getContext().getContentResolver(), uri));
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static class InitResult {
        final int mSourceResId;
        final int mBackgroundResId;
        final boolean mFreezesAnimation;

        InitResult(int sourceResId, int backgroundResId, boolean freezesAnimation) {
            this.mSourceResId = sourceResId;
            this.mBackgroundResId = backgroundResId;
            this.mFreezesAnimation = freezesAnimation;
        }
    }
}

