/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;

public class OnBoardingCloud
extends RelativeLayout {
    public static final String ON_BOARDING_SHARED_PREFERENCES_KEY = "ON_BOARDING_SHARED_PREFERENCES_KEY";
    private final long ON_BOARDING_ENTER_DELAY_ANIMATION = 500L;
    private final long ON_BOARDING_EXIT_DELAY_ANIMATION = 2200L;
    private final long FADE_IN_ANIMATION_DURATION = 1000L;
    private final long FADE_OUT_ANIMATION_DURATION = 700L;
    private View mBackgroundView;
    private View mAnimationView;
    private View mRootView;
    private OnBoardingCloudInterface mOnBoardingCloudInterface;

    public OnBoardingCloud(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.initRootView();
        this.initBackgroundView();
        this.initAnimationView();
    }

    private void initBackgroundView() {
        this.mBackgroundView = this.mRootView.findViewById(R.id.BackgroundView);
        this.mBackgroundView.setClickable(true);
        this.mBackgroundView.setVisibility(4);
    }

    private void initAnimationView() {
        this.mAnimationView = this.mRootView.findViewById(R.id.AnimationView);
        this.mAnimationView.setVisibility(4);
    }

    private void initRootView() {
        this.mRootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.on_boarding_cloud, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(this.mRootView, (ViewGroup.LayoutParams)params);
    }

    public void animateView(OnBoardingCloudInterface onBoardingCloudInterface) {
        this.mOnBoardingCloudInterface = onBoardingCloudInterface;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                AnimationsUtils.animateFade(OnBoardingCloud.this.mBackgroundView, true, 1000L, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        OnBoardingCloud.this.mBackgroundView.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                GenAnimator.playOnBoardingCloudDropAnimation(OnBoardingCloud.this.mAnimationView, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        OnBoardingCloud.this.mAnimationView.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                        OnBoardingCloud.this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                AnimationsUtils.animateFade(OnBoardingCloud.this.mBackgroundView, false, 700L, new Animator.AnimatorListener(){

                                    public void onAnimationStart(Animator animation) {
                                    }

                                    public void onAnimationEnd(Animator animation) {
                                        OnBoardingCloud.this.mBackgroundView.setVisibility(8);
                                        if (OnBoardingCloud.this.mOnBoardingCloudInterface != null) {
                                            OnBoardingCloud.this.mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    public void onAnimationCancel(Animator animation) {
                                        OnBoardingCloud.this.mBackgroundView.setVisibility(8);
                                        if (OnBoardingCloud.this.mOnBoardingCloudInterface != null) {
                                            OnBoardingCloud.this.mOnBoardingCloudInterface.onFinished();
                                        }
                                    }

                                    public void onAnimationRepeat(Animator animation) {
                                    }
                                });
                                GenAnimator.playPopOutAnimation(OnBoardingCloud.this.mAnimationView, new Animator.AnimatorListener(){

                                    public void onAnimationStart(Animator animation) {
                                    }

                                    public void onAnimationEnd(Animator animation) {
                                        OnBoardingCloud.this.mAnimationView.setVisibility(8);
                                    }

                                    public void onAnimationCancel(Animator animation) {
                                    }

                                    public void onAnimationRepeat(Animator animation) {
                                    }
                                });
                            }
                        }, 2200L);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }, 500L);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public static interface OnBoardingCloudInterface {
        public void onFinished();
    }
}

