/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.AccelerateInterpolator;
import android.widget.RelativeLayout;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.kidoz.sdk.api.picasso_related.RoundedTransformation;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ContentItemView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class ItemsBaseRecycleViewAdapter
extends RecyclerView.Adapter<ViewHolder>
implements View.OnClickListener {
    private final String TAG = ItemsBaseRecycleViewAdapter.class.getSimpleName();
    private final int POP_UP_ANIMATION_DURATION = 350;
    public static final float SECONDARY_THUMB_SIZE_RELATIVE_TO_ITEM_WIDHT = 0.24f;
    public static final float MAIN_THUMB_DEFAULT_ITEM_HEIGHT_RELATIVE_TO_WIDHT_VERTICAL = 0.5f;
    public static final float HORIZONTAL_TYPE_ITEM_HEIGHT_RATIO = 0.8f;
    public static final float HORIZONTAL_TYPE_ITEM_THUMB_HEIGHT_RATIO = 0.7f;
    protected boolean mIsRegularAnimation;
    private ArrayList<ContentItem> mContentArrayList;
    private Context mContext;
    private int mItemWidth;
    private int mItemHeight;
    private int mContentTypeThubmnailSize;
    private float mFixedItemRation = 0.0f;
    private AdapterTypeScroling mAdapterTypeScroling = AdapterTypeScroling.VERTICAL;
    private AbstractContentPanel.IOnContentItemClickListener mOnItemClickListener;
    private HashSet<Integer> animationExecutedSet = new HashSet();
    private boolean mIsAnimationClick = false;
    private int mCurrentThumbWidth;
    private int mCurrentThumbHeight;
    private int mSpanCount;
    int roundedCorners;
    private int mLastPosition = -1;
    private AccelerateInterpolator mAnimationInterpolator;
    private Handler mHandler;
    private HashMap<String, Integer> mSponsoredContentDisplayed = new HashMap();

    public ItemsBaseRecycleViewAdapter(Context context, ArrayList<ContentItem> itemsList, int spanCount, AdapterTypeScroling typeScroling, int itemHeight) {
        this.mHandler = new Handler();
        this.mAnimationInterpolator = new AccelerateInterpolator();
        this.mContentArrayList = itemsList;
        this.mContext = context;
        this.mAdapterTypeScroling = typeScroling;
        this.mItemHeight = itemHeight;
        this.roundedCorners = Utils.dpTOpx(this.mContext, 4);
        this.setSpanCount(spanCount, this.mContext.getResources().getConfiguration().orientation);
    }

    public void setSpanCount(int count, int orientation) {
        this.mSpanCount = count;
        Rect rectangle = new Rect();
        if (this.mContext instanceof Activity && orientation == 2) {
            Window window = ((Activity)this.mContext).getWindow();
            window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            this.mItemWidth = rectangle.width();
        } else {
            Point point = Utils.getScreenSize(this.mContext);
            this.mItemWidth = point.x;
        }
        if (this.mAdapterTypeScroling == AdapterTypeScroling.VERTICAL) {
            this.mItemWidth = this.mItemWidth / count - (Utils.dpTOpx(this.mContext, 2) * 2 + Utils.dpTOpx(this.mContext, 4) * 2);
        } else if (this.mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL) {
            this.mItemHeight -= ContentItemView.getViewMargin(this.mContext);
            this.mItemWidth = (int)((float)this.mItemHeight / 0.8f);
        }
        this.mContentTypeThubmnailSize = (int)((float)this.mItemWidth * 0.24f);
    }

    public void setFixedItemRatio(float ratio) {
        this.mFixedItemRation = ratio;
    }

    public void setHorizontalItemHeight(int height) {
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ContentItemView convertView = new ContentItemView(this.mContext);
        ViewHolder viewHolder = new ViewHolder(convertView);
        return viewHolder;
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        if (holder != null) {
            ContentItem contentItem = this.mContentArrayList.get(position);
            this.sendImpressionLog(holder, contentItem, position);
            holder.mRootView.getNameTextView().setText((CharSequence)contentItem.getName());
            if (this.mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL) {
                holder.mRootView.getNameTextView().setLines(1);
            } else if (this.mAdapterTypeScroling == AdapterTypeScroling.VERTICAL) {
                holder.mRootView.getNameTextView().setLines(2);
            }
            this.setCorrectItemSize(holder, contentItem);
            this.loadSecondaryThumbnail(holder, contentItem);
            if (position > this.mLastPosition) {
                long delay = !this.mIsRegularAnimation ? (long)(position * 350) : 0L;
                holder.mRootView.setVisibility(4);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GenAnimator.recycleItemAnimation((View)holder.mRootView, new GenAnimator.ViewAnimationListener(){

                            @Override
                            public void onAnimationEnd() {
                            }

                            @Override
                            public void onAnimationStart() {
                                holder.mRootView.setVisibility(0);
                            }
                        });
                    }
                }, delay);
                this.mLastPosition = position;
            } else {
                holder.mRootView.clearAnimation();
                holder.mRootView.setVisibility(0);
            }
        }
    }

    public void setIsRegularAnimation(boolean isRegularAnimation) {
        this.mIsRegularAnimation = isRegularAnimation;
    }

    private void setCorrectItemSize(ViewHolder viewHolder, ContentItem contentItem) {
        if (contentItem != null) {
            if (this.mAdapterTypeScroling == AdapterTypeScroling.VERTICAL) {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)viewHolder.mRootView.getMainThumbView().getLayoutParams();
                int itemWidth = this.mItemWidth;
                int itemHeight = (int)((float)itemWidth * 0.5f);
                if (params.height != itemHeight) {
                    params.height = itemHeight;
                }
                if (params.width != itemWidth) {
                    params.width = itemWidth;
                }
                this.mCurrentThumbWidth = itemWidth;
                this.mCurrentThumbHeight = itemHeight;
            } else if (this.mAdapterTypeScroling == AdapterTypeScroling.HORIZONTAL) {
                ViewGroup.LayoutParams params = viewHolder.mRootView.getLayoutParams();
                params.height = this.mItemHeight;
                params.width = this.mItemWidth;
                RelativeLayout.LayoutParams relParams = (RelativeLayout.LayoutParams)viewHolder.mRootView.getMainThumbView().getLayoutParams();
                relParams.height = (int)((float)this.mItemHeight * 0.7f);
                this.mCurrentThumbWidth = this.mItemWidth;
                this.mCurrentThumbHeight = relParams.height;
            }
            if (this.mCurrentThumbWidth > 0 && this.mCurrentThumbHeight > 0) {
                this.loadMainThumbnail(viewHolder, contentItem, this.mCurrentThumbWidth, this.mCurrentThumbHeight);
            }
        }
    }

    private void loadMainThumbnail(ViewHolder viewHolder, ContentItem contentItem, int widht, int height) {
        if (contentItem != null) {
            viewHolder.mRootView.getMainThumbView().setImageBitmap(null);
            viewHolder.mRootView.getNameTextView().setTextColor(contentItem.getPaliteTextColor());
            viewHolder.mRootView.setItemBgColor(contentItem.getPaliteBgColor());
            PicassoOk.getPicasso(this.mContext).load(contentItem.getThumb()).transform(new RoundedTransformation(this.roundedCorners, 0)).resize(widht, height).centerCrop().into(viewHolder.mRootView.getMainThumbView());
        }
    }

    private void loadSecondaryThumbnail(ViewHolder viewHolder, ContentItem contentItem) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)viewHolder.mRootView.getSecondaryThumbView().getLayoutParams();
        params.height = this.mContentTypeThubmnailSize;
        params.width = this.mContentTypeThubmnailSize;
        params.rightMargin = (int)((double)this.mContentTypeThubmnailSize * 0.22);
        params.bottomMargin = (int)((double)this.mContentTypeThubmnailSize * 0.5) * -1;
        PicassoOk.getPicasso(this.mContext).load(contentItem.getSecThumb()).into(viewHolder.mRootView.getSecondaryThumbView());
    }

    public void setOnItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setContentData(ArrayList<ContentItem> items, boolean toStart) {
        this.mSponsoredContentDisplayed.clear();
        if (toStart) {
            this.animationExecutedSet.clear();
            this.mContentArrayList.addAll(0, items);
        } else {
            this.mContentArrayList.addAll(this.mContentArrayList.size(), items);
        }
    }

    public void setContentDataWithNotify(ArrayList<ContentItem> items, boolean toStart) {
        this.mSponsoredContentDisplayed.clear();
        if (toStart) {
            this.animationExecutedSet.clear();
            this.mContentArrayList.addAll(0, items);
            this.notifyItemRangeInserted(0, items.size() - 1);
            this.notifyItemRangeChanged(0, this.mContentArrayList.size() - 1);
        } else {
            int size = this.mContentArrayList.size();
            this.mContentArrayList.addAll(items);
            this.notifyItemRangeInserted(size, this.mContentArrayList.size());
            this.notifyItemRangeChanged(0, this.mContentArrayList.size());
        }
    }

    public void clearContentDataWithNotify() {
        this.animationExecutedSet.clear();
        int size = this.mContentArrayList.size();
        this.mContentArrayList.clear();
        this.notifyItemRangeRemoved(0, size);
        this.notifyItemRangeChanged(0, size);
    }

    public boolean isEmpty() {
        if (this.mContentArrayList != null) {
            return this.mContentArrayList.isEmpty();
        }
        return true;
    }

    public ArrayList<ContentItem> getData() {
        return this.mContentArrayList;
    }

    public int getItemCount() {
        return this.mContentArrayList.size();
    }

    public void onClick(final View view) {
        if (!this.mIsAnimationClick) {
            this.mIsAnimationClick = true;
            GenAnimator.clickItemAnimation(view, 90, new GenAnimator.ViewAnimationListener(){

                @Override
                public void onAnimationEnd() {
                    ViewHolder viewHolder;
                    if (ItemsBaseRecycleViewAdapter.this.mOnItemClickListener != null && (viewHolder = (ViewHolder)((Object)view.getTag())).getAdapterPosition() != -1) {
                        ContentItem contentItem = (ContentItem)ItemsBaseRecycleViewAdapter.this.mContentArrayList.get(viewHolder.getAdapterPosition());
                        ItemsBaseRecycleViewAdapter.this.mOnItemClickListener.onItemClick(contentItem, viewHolder.getAdapterPosition());
                    }
                    ItemsBaseRecycleViewAdapter.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ItemsBaseRecycleViewAdapter.this.mIsAnimationClick = false;
                        }
                    }, 300L);
                }

                @Override
                public void onAnimationStart() {
                }
            });
        }
    }

    public int getItemOuterMargin() {
        return ContentItemView.getViewMargin(this.mContext);
    }

    private void sendImpressionLog(ViewHolder viewHolder, ContentItem contentItem, int position) {
        if (contentItem != null && contentItem.isPromoted() && this.mSponsoredContentDisplayed != null && !this.mSponsoredContentDisplayed.containsKey(contentItem.getId())) {
            this.mSponsoredContentDisplayed.put(contentItem.getId(), new Integer(position));
            EventManager.getInstance().logSponsoredContentImpressionEvent(viewHolder.mRootView.getContext(), "Impression Viewed", contentItem.getName(), contentItem.getAdvertiserID(), contentItem.getId(), position);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ContentItemView mRootView;
        private AnimatorSet mItemAnimatorSet;

        public ViewHolder(ContentItemView rootView) {
            super((View)rootView);
            this.mRootView = rootView;
            this.mRootView.setOnClickListener(ItemsBaseRecycleViewAdapter.this);
            this.mRootView.setTag((Object)this);
        }
    }

    protected static enum AdapterTypeScroling {
        HORIZONTAL,
        VERTICAL;

    }
}

