/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private boolean mShowFirstDivider = false;
    private boolean mShowLastDivider = false;

    public DividerItemDecoration(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16843284});
        this.mDivider = a.getDrawable(0);
        a.recycle();
    }

    public DividerItemDecoration(Context context, AttributeSet attrs, boolean showFirstDivider, boolean showLastDivider) {
        this(context, attrs);
        this.mShowFirstDivider = showFirstDivider;
        this.mShowLastDivider = showLastDivider;
    }

    public DividerItemDecoration(Drawable divider) {
        this.mDivider = divider;
    }

    public DividerItemDecoration(Drawable divider, boolean showFirstDivider, boolean showLastDivider) {
        this(divider);
        this.mShowFirstDivider = showFirstDivider;
        this.mShowLastDivider = showLastDivider;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mDivider == null) {
            return;
        }
        if (parent.getChildPosition(view) < 1) {
            return;
        }
        if (this.getOrientation(parent) == 1) {
            outRect.top = this.mDivider.getIntrinsicHeight();
        } else {
            outRect.left = this.mDivider.getIntrinsicWidth();
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int i;
        int size;
        if (this.mDivider == null) {
            super.onDrawOver(c, parent, state);
            return;
        }
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int orientation = this.getOrientation(parent);
        int childCount = parent.getChildCount();
        if (orientation == 1) {
            size = this.mDivider.getIntrinsicHeight();
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
        } else {
            size = this.mDivider.getIntrinsicWidth();
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
        }
        int n = i = this.mShowFirstDivider ? 0 : 1;
        while (i < childCount) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (orientation == 1) {
                top = child.getTop() - params.topMargin;
                bottom = top + size;
            } else {
                left = child.getLeft() - params.leftMargin;
                right = left + size;
            }
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
            ++i;
        }
        if (this.mShowLastDivider && childCount > 0) {
            View child = parent.getChildAt(childCount - 1);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (orientation == 1) {
                top = child.getBottom() + params.bottomMargin;
                bottom = top + size;
            } else {
                left = child.getRight() + params.rightMargin;
                right = left + size;
            }
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    private int getOrientation(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            return layoutManager.getOrientation();
        }
        throw new IllegalStateException("DividerItemDecoration can only be used with a LinearLayoutManager.");
    }
}

