/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemVerticalRecycleViewAdapter;
import com.kidoz.sdk.api.ui_views.RecycleEndlessScrollListener;
import java.util.ArrayList;

public class ContentPanelView
extends AbstractContentPanel {
    private RecyclerView mRecyclerView;
    private RecycleEndlessScrollListener endlesScollPaginghandler;
    private ItemVerticalRecycleViewAdapter mAdapter;
    private StaggeredGridLayoutManager mStaggaredLayoutManager;
    private GridLayoutManager mGridLayoutManager;
    private LinearLayoutManager mLinearLayoutManager;
    private SwipeRefreshLayout swipeRefreshLayout;
    private LayoutViewType mLayoutViewType = LayoutViewType.STAGGERED;
    private ArrayList<ContentItem> mItemsList = new ArrayList();
    private int[] fPos = new int[3];
    private int[] lPos = new int[3];
    private int mCurrentVisiblePosition = 0;

    public ContentPanelView(Context context, LayoutViewType layoutViewType) {
        super(context);
        this.mLayoutViewType = layoutViewType;
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPanelView(context);
    }

    public ContentPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPanelView(context);
    }

    @Override
    public void initPanelView(Context context) {
        this.initSwipeRefreshLayout(context);
        this.initRecyclerView(context);
        this.initAdaper();
        this.initLaoutManager();
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.swipeRefreshLayout.addView((View)this.mRecyclerView, layoutParams);
        RelativeLayout.LayoutParams relParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.swipeRefreshLayout, (ViewGroup.LayoutParams)relParams);
    }

    private void initSwipeRefreshLayout(Context context) {
        this.swipeRefreshLayout = new SwipeRefreshLayout(context);
        this.swipeRefreshLayout.setOnRefreshListener(null);
        this.swipeRefreshLayout.setEnabled(false);
        this.swipeRefreshLayout.setColorSchemeColors(new int[]{-65536, -7829368, -16711681});
    }

    private void initRecyclerView(Context context) {
        this.mRecyclerView = new RecyclerView(context);
        this.mRecyclerView.setClipToPadding(false);
        Point point = Utils.getScreenSize(this.getContext());
        int paddingBottom = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        int paddingTop = (int)((float)Math.max(point.x, point.y) * 0.061458334f);
        this.mRecyclerView.setPadding(0, paddingTop, 0, paddingBottom);
    }

    private void initLaoutManager() {
        this.setLayoutManagerView(this.mLayoutViewType);
    }

    private void initAdaper() {
        this.mAdapter = new ItemVerticalRecycleViewAdapter(this.getContext(), this.mItemsList, this.getCurrentSpanCount());
        this.endlesScollPaginghandler = new RecycleEndlessScrollListener(4){

            @Override
            public void onLoadMore(int page, int totalItemsCount) {
                if (totalItemsCount > 0) {
                    // empty if block
                }
            }
        };
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                ContentPanelView.this.mAdapter.setIsRegularAnimation(true);
                try {
                    if (ContentPanelView.this.mLayoutViewType == LayoutViewType.GRID || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_HORIZONTAL || ContentPanelView.this.mLayoutViewType == LayoutViewType.LINEAR_VERTICAL) {
                        ((ContentPanelView)ContentPanelView.this).fPos[0] = ContentPanelView.this.mGridLayoutManager.findFirstVisibleItemPosition();
                        ((ContentPanelView)ContentPanelView.this).lPos[0] = ContentPanelView.this.mGridLayoutManager.findLastVisibleItemPosition();
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    } else if (ContentPanelView.this.mLayoutViewType == LayoutViewType.STAGGERED) {
                        ContentPanelView.this.mStaggaredLayoutManager.findFirstVisibleItemPositions(ContentPanelView.this.fPos);
                        ContentPanelView.this.mStaggaredLayoutManager.findLastVisibleItemPositions(ContentPanelView.this.lPos);
                        ContentPanelView.this.endlesScollPaginghandler.onScroll(ContentPanelView.this.fPos[0], ContentPanelView.this.lPos[0] - ContentPanelView.this.fPos[0], ContentPanelView.this.mItemsList.size());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ContentPanelView.this.mCurrentVisiblePosition = ContentPanelView.this.fPos[0];
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                try {
                    super.onScrollStateChanged(recyclerView, newState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (this.mCurrentVisiblePosition != 0) {
            this.mRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
        }
    }

    private int getCurrentSpanCount() {
        return KidozSDK.getCreativeToolsData().getNumberOfColumns(this.getContext());
    }

    public void setLayoutManagerView(LayoutViewType viewType) {
        this.mLayoutViewType = viewType;
        switch (viewType) {
            case STAGGERED: {
                this.mStaggaredLayoutManager = new StaggeredGridLayoutManager(this.getCurrentSpanCount(), 1);
                this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mStaggaredLayoutManager);
                break;
            }
            case GRID: {
                this.mGridLayoutManager = new GridLayoutManager(this.getContext(), this.getCurrentSpanCount());
                this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mGridLayoutManager);
                break;
            }
            case LINEAR_HORIZONTAL: {
                this.mLinearLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
                this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
                break;
            }
            case LINEAR_VERTICAL: {
                this.mLinearLayoutManager = new LinearLayoutManager(this.getContext(), 1, false);
                this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
            }
        }
    }

    public void setRoundingCorenrsValue(int rounding) {
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        if (this.mAdapter != null) {
            this.mAdapter.setOnItemClickListener(listener);
        }
    }

    public void clearDataFromView() {
        this.mItemsList.clear();
        this.mAdapter.clearContentDataWithNotify();
    }

    public void addDatandRefreshView(ArrayList<ContentItem> list) {
        if (list != null) {
            this.mItemsList.addAll(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void screenStatusChanged(boolean screenOn) {
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int spanCount = this.getCurrentSpanCount();
        this.mAdapter.setSpanCount(spanCount, newConfig.orientation);
        this.setLayoutManagerView(this.mLayoutViewType);
        this.mRecyclerView.scrollToPosition(this.mCurrentVisiblePosition);
    }

    public static enum LayoutViewType {
        STAGGERED,
        GRID,
        LINEAR_VERTICAL,
        LINEAR_HORIZONTAL;

    }
}

