/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import com.kidoz.sdk.api.ui_views.ItemHorizontalRecycleViewAdapter;
import java.util.ArrayList;

public class ContentHorizontalPanelView
extends AbstractContentPanel {
    public static final int INNER_RECYCLER_VIEW_MARGIN_DP = 2;
    public static final int INNER_RECYCLER_VIEW_PADDING_DP = 2;
    private ItemHorizontalRecycleViewAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private AbstractContentPanel.IOnContentItemClickListener mClickListener;
    private int mViewRealHeight = -1;
    private int mPadding;
    private int mMargin;
    private ArrayList<ContentItem> mContentItems = new ArrayList();

    public ContentHorizontalPanelView(Context context, int height) {
        super(context);
        this.initPanelView(context);
        this.mViewRealHeight = height;
    }

    public ContentHorizontalPanelView(Context context) {
        super(context);
        this.initPanelView(context);
    }

    public ContentHorizontalPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ContentHorizontalPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void initPanelView(Context context) {
        this.mPadding = Utils.dpTOpx(context, 2);
        this.mMargin = Utils.dpTOpx(context, 2);
        this.mRecyclerView = new RecyclerView(this.getContext());
        this.mLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mRecyclerView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        this.reinstaniateAdapter();
        LinearLayout mLinearLayout = new LinearLayout(context);
        mLinearLayout.setGravity(16);
        LinearLayout.LayoutParams linParams = new LinearLayout.LayoutParams(-1, -1);
        linParams.setMargins(0, this.mMargin, 0, this.mMargin);
        mLinearLayout.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)linParams);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(15);
        this.addView((View)mLinearLayout, (ViewGroup.LayoutParams)params);
        if (this.mViewRealHeight == -1) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        ContentHorizontalPanelView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        ContentHorizontalPanelView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    ContentHorizontalPanelView.this.mViewRealHeight = ContentHorizontalPanelView.this.getHeight() - ContentHorizontalPanelView.this.mMargin * 2 - ContentHorizontalPanelView.this.mPadding * 2;
                    ContentHorizontalPanelView.this.reinstaniateAdapter();
                }
            });
        }
    }

    private void reinstaniateAdapter() {
        this.mAdapter = new ItemHorizontalRecycleViewAdapter(this.getContext(), this.mContentItems, this.mViewRealHeight);
        if (this.mClickListener != null) {
            this.mAdapter.setOnItemClickListener(this.mClickListener);
        }
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public void setOnContentItemClickListener(AbstractContentPanel.IOnContentItemClickListener contentListener) {
        this.mClickListener = contentListener;
        if (this.mAdapter != null) {
            this.mAdapter.setOnItemClickListener(contentListener);
        }
    }

    public void setContent(ArrayList<ContentItem> content) {
        if (this.mAdapter != null) {
            this.mAdapter.setContentData(content, false);
            this.mLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mLayoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
    }

    public boolean isEmpty() {
        return this.mContentItems.isEmpty();
    }
}

