/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.LockIconData;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParentalLockData {
    private final String TAG = ParentalLockData.class.getSimpleName();
    private boolean mIsActivated;
    private ArrayList<LockIconData> mLockIconArrayList;

    public ParentalLockData() {
    }

    public ParentalLockData(JSONObject jSONObject) {
        if (jSONObject != null) {
            try {
                if (jSONObject.has("is_parental_lock_activated") && !jSONObject.isNull("is_parental_lock_activated")) {
                    this.mIsActivated = jSONObject.getBoolean("is_parental_lock_activated");
                }
                if (jSONObject.has("lock_icons") && !jSONObject.isNull("lock_icons")) {
                    this.mLockIconArrayList = new ArrayList();
                    JSONArray lockIconsArray = jSONObject.getJSONArray("lock_icons");
                    if (lockIconsArray.length() > 1) {
                        HashMap<String, Integer> keysHashMap = new HashMap<String, Integer>();
                        JSONArray keysJSONArray = lockIconsArray.getJSONArray(0);
                        for (int keyIndex = 0; keyIndex < keysJSONArray.length(); ++keyIndex) {
                            keysHashMap.put(keysJSONArray.getString(keyIndex), keyIndex);
                        }
                        for (int lockIconIndex = 1; lockIconIndex < lockIconsArray.length(); ++lockIconIndex) {
                            JSONArray nextJSONArray = lockIconsArray.getJSONArray(lockIconIndex);
                            LockIconData nextLockIconData = new LockIconData(nextJSONArray, keysHashMap);
                            this.mLockIconArrayList.add(nextLockIconData);
                        }
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(this.TAG, "Error creating parental lock data: " + ex.getMessage());
            }
        }
    }

    public boolean getIsActivated() {
        return this.mIsActivated;
    }

    public void setIsActivated(boolean isActivated) {
        this.mIsActivated = isActivated;
    }

    public ArrayList<LockIconData> getLockIconArrayList() {
        return this.mLockIconArrayList;
    }

    public void setLockIconArrayList(ArrayList<LockIconData> lockIconArrayList) {
        this.mLockIconArrayList = lockIconArrayList;
    }
}

