/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.structure;

import android.content.Context;
import com.kidoz.sdk.api.general.utils.Utils;

public class CreativeToolsData {
    private int mNumberOfColumnsInPortraitPhone = Integer.MIN_VALUE;
    private int mNumberOfColumnsInLandscapePhone = Integer.MIN_VALUE;
    private int mNumberOfColumnsInPortraitTablet = Integer.MIN_VALUE;
    private int mNumberOfColumnsInLandscapeTablet = Integer.MIN_VALUE;

    public int getNumberOfColumns(Context context) {
        int result = 2;
        if (context.getResources().getConfiguration().orientation == 2) {
            if (Utils.getIsDeviceTablet(context)) {
                result = 3;
                if (this.mNumberOfColumnsInLandscapeTablet != Integer.MIN_VALUE) {
                    result = this.mNumberOfColumnsInLandscapeTablet;
                }
            } else {
                result = 2;
                if (this.mNumberOfColumnsInLandscapePhone != Integer.MIN_VALUE) {
                    result = this.mNumberOfColumnsInLandscapePhone;
                }
            }
        } else if (Utils.getIsDeviceTablet(context)) {
            result = 2;
            if (this.mNumberOfColumnsInPortraitTablet != Integer.MIN_VALUE) {
                result = this.mNumberOfColumnsInPortraitTablet;
            }
        } else {
            result = 2;
            if (this.mNumberOfColumnsInPortraitPhone != Integer.MIN_VALUE) {
                result = this.mNumberOfColumnsInPortraitPhone;
            }
        }
        return result;
    }

    public void setNumberOfColumns(NUMBER_OF_COLUMNS_CONFIGURATION numberOfColumnsConfiguration, int numberOfColumns) {
        if (numberOfColumnsConfiguration != null) {
            switch (numberOfColumnsConfiguration) {
                case PHONE_LANDSCAPE: {
                    this.mNumberOfColumnsInLandscapePhone = numberOfColumns;
                    break;
                }
                case PHONE_PORTRAIT: {
                    this.mNumberOfColumnsInPortraitPhone = numberOfColumns;
                    break;
                }
                case TABLET_LANDSCAPE: {
                    this.mNumberOfColumnsInLandscapeTablet = numberOfColumns;
                    break;
                }
                case TABLET_PORTRAIT: {
                    this.mNumberOfColumnsInPortraitTablet = numberOfColumns;
                }
            }
        }
    }

    public static enum NUMBER_OF_COLUMNS_CONFIGURATION {
        TABLET_LANDSCAPE,
        TABLET_PORTRAIT,
        PHONE_LANDSCAPE,
        PHONE_PORTRAIT;

    }
}

