/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.fragments;

import android.os.Bundle;
import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.YouTubePlayerSupportFragment;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;

public class VideoFragment
extends YouTubePlayerSupportFragment
implements YouTubePlayer.OnInitializedListener {
    public static String TAG = VideoFragment.class.getSimpleName();
    private static final String YOU_TUBE_DEVELOPER_ID = "AIzaSyCO0ANo6o7l286UdA4LHBvzTZ6Aza79lTc";
    private YouTubePlayer mYouTubePlayer;
    private String mVideoID;
    private VideoPlayerListener mVideoPlayerListener;
    private YouTubePlayer.PlaybackEventListener mPlaybackEventListener;
    private YouTubePlayer.OnFullscreenListener mOnFullscreenListener;

    public static VideoFragment newInstance() {
        return new VideoFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initialize(YOU_TUBE_DEVELOPER_ID, this);
    }

    public void onDestroy() {
        try {
            if (this.mYouTubePlayer != null) {
                this.mYouTubePlayer.release();
                this.mYouTubePlayer = null;
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to onDestroy: " + ex.getMessage());
        }
        super.onDestroy();
    }

    public void setVideoId(String videoId) {
        try {
            if (videoId != null && !videoId.equals(this.mVideoID)) {
                this.mVideoID = videoId;
                if (this.mYouTubePlayer != null) {
                    this.mYouTubePlayer.loadVideo(videoId);
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to set video ID: " + ex.getMessage());
        }
    }

    public void refreshVideo() {
        if (this.mVideoID != null) {
            try {
                if (this.mYouTubePlayer != null) {
                    this.mYouTubePlayer.release();
                    this.mYouTubePlayer = null;
                }
                this.initialize(YOU_TUBE_DEVELOPER_ID, this);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to refreshVideo: " + ex.getMessage());
            }
        }
    }

    public void playVideo() {
        try {
            if (this.mYouTubePlayer != null && !this.mYouTubePlayer.isPlaying() && this.mVideoID != null) {
                this.mYouTubePlayer.play();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to playVideo: " + ex.getMessage());
        }
    }

    public void pauseVideo() {
        try {
            if (this.mYouTubePlayer != null) {
                this.mYouTubePlayer.pause();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to pauseVideo: " + ex.getMessage());
        }
    }

    public void onPause() {
        super.onPause();
        try {
            if (this.mYouTubePlayer != null) {
                this.mYouTubePlayer.pause();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to onPause: " + ex.getMessage());
        }
    }

    public void onInitializationSuccess(YouTubePlayer.Provider provider, YouTubePlayer youTubePlayer, boolean restored) {
        try {
            this.mYouTubePlayer = youTubePlayer;
            this.initYouTubePlayer();
            if (!restored && this.mVideoID != null) {
                this.mYouTubePlayer.loadVideo(this.mVideoID);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to onInitializationSuccess: " + ex.getMessage());
        }
    }

    public void onInitializationFailure(YouTubePlayer.Provider provider, YouTubeInitializationResult result) {
        try {
            this.mYouTubePlayer = null;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to onInitializationFailure: " + ex.getMessage());
        }
    }

    private void initYouTubePlayer() {
        try {
            this.mYouTubePlayer.setPlayerStyle(YouTubePlayer.PlayerStyle.CHROMELESS);
            this.mYouTubePlayer.setPlayerStateChangeListener(new YouTubePlayer.PlayerStateChangeListener(){

                public void onLoading() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onLoading();
                    }
                }

                public void onLoaded(String s) {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onFinishedLoading();
                    }
                }

                public void onAdStarted() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        // empty if block
                    }
                }

                public void onVideoStarted() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onVideoStarted();
                    }
                }

                public void onVideoEnded() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onVideoEnded();
                    }
                }

                public void onError(YouTubePlayer.ErrorReason errorReason) {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onError(errorReason.toString());
                    }
                }
            });
            this.mYouTubePlayer.setPlaybackEventListener(new YouTubePlayer.PlaybackEventListener(){

                public void onPlaying() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onPlaying();
                    }
                    if (VideoFragment.this.mPlaybackEventListener != null) {
                        VideoFragment.this.mPlaybackEventListener.onPlaying();
                    }
                }

                public void onPaused() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onPaused();
                    }
                    if (VideoFragment.this.mPlaybackEventListener != null) {
                        VideoFragment.this.mPlaybackEventListener.onPaused();
                    }
                }

                public void onStopped() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onStopped();
                    }
                    if (VideoFragment.this.mPlaybackEventListener != null) {
                        VideoFragment.this.mPlaybackEventListener.onStopped();
                    }
                }

                public void onBuffering(boolean b) {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onBuffering(b);
                    }
                }

                public void onSeekTo(int i) {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onSeekTo(i);
                    }
                }
            });
            this.mYouTubePlayer.setPlaylistEventListener(new YouTubePlayer.PlaylistEventListener(){

                public void onPrevious() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onPrevious();
                    }
                }

                public void onNext() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onNext();
                    }
                }

                public void onPlaylistEnded() {
                    if (VideoFragment.this.mVideoPlayerListener != null) {
                        VideoFragment.this.mVideoPlayerListener.onPlaylistEnded();
                    }
                }
            });
            this.mYouTubePlayer.addFullscreenControlFlag(8);
            this.mYouTubePlayer.setOnFullscreenListener(this.mOnFullscreenListener);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to initYouTubePlayer: " + ex.getMessage());
        }
    }

    public void toggleFullScreen(boolean isOpenInFullScreen) {
        try {
            if (this.mYouTubePlayer != null) {
                this.mYouTubePlayer.setFullscreen(isOpenInFullScreen);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to toggleFullScreen: " + ex.getMessage());
        }
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener) {
        this.mVideoPlayerListener = videoPlayerListener;
    }

    public void setOnFullscreenListener(YouTubePlayer.OnFullscreenListener onFullscreenListener) {
        this.mOnFullscreenListener = onFullscreenListener;
    }

    public void setWrapperPlaybackEventListener(YouTubePlayer.PlaybackEventListener playbackEventListener) {
        this.mPlaybackEventListener = playbackEventListener;
    }

    public boolean getIsPlaying() {
        boolean result = false;
        try {
            if (this.mYouTubePlayer != null) {
                result = this.mYouTubePlayer.isPlaying();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to getIsPlaying: " + ex.getMessage());
        }
        return result;
    }

    public void seekVideo(int progressMilliseconds) {
        try {
            if (this.mYouTubePlayer != null) {
                this.mYouTubePlayer.seekToMillis(progressMilliseconds);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to seekVideo: " + ex.getMessage());
        }
    }

    public long getVideoCurrentTime() {
        long result = 0L;
        try {
            if (this.mYouTubePlayer != null) {
                result = this.mYouTubePlayer.getCurrentTimeMillis();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to getVideoCurrentTime: " + ex.getMessage());
        }
        return result;
    }

    public long getVideoTotalTime() {
        long result = 0L;
        try {
            if (this.mYouTubePlayer != null) {
                result = this.mYouTubePlayer.getDurationMillis();
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to getVideoTotalTime: " + ex.getMessage());
        }
        return result;
    }
}

