/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import com.google.android.youtube.player.YouTubePlayer;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.players.video_player.logics.VideoPlayerListener;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.InterceptableTouchEventRelativeLayout;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.PlayAndPauseButton;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.RelatedContentLandscapeContainer;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.RelatedContentPortraitContainer;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.SeekBarController;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.VideoPlayerTopBar;
import com.kidoz.sdk.api.players.video_player.ui.fragments.VideoFragment;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.AbstractContentPanel;
import java.util.ArrayList;

public class VideoPlayerController {
    private final String TAG = VideoPlayerController.class.getSimpleName();
    private static final float VIDEO_WINDOW_RATIO = 0.315f;
    private Context mContext;
    private View mRootView;
    private RelativeLayout.LayoutParams mVideoContainerLayoutParams;
    private InterceptableTouchEventRelativeLayout mVideoControllerContainer;
    private PlayAndPauseButton mPlayAndPauseButton;
    private SeekBarController mSeekBarController;
    private VideoPlayerTopBar mVideoPlayerTopBar;
    private RelatedContentPortraitContainer mRelatedContentPortraitContainer;
    private RelatedContentLandscapeContainer mRelatedContentLandscapeContainer;
    private VideoPlayerListener mVideoPlayerListener;
    private VideoFragment mVideoFragment;
    private FrameLayout mVideoPlayerContainerFrameLayout;
    private int mLandscapeRelatedContainerHideTranslateValue;
    private Handler mHandler = new Handler();
    private boolean mIsUserPauseVideo;

    public VideoPlayerController(Context context) {
        this.mContext = context;
        this.initView();
        this.fixVideoLayout();
    }

    private void initView() {
        this.initRootView();
        this.initVideoContainerLayout();
        this.initTopBar();
        this.initSeekBarController();
        this.initRelatedContentPortraitContainer();
        this.initRelatedContentLandscapeContainer();
        this.initPlayAndPauseButton();
    }

    private void initRelatedContentPortraitContainer() {
        this.mRelatedContentPortraitContainer = (RelatedContentPortraitContainer)this.mRootView.findViewById(R.id.RelatedContentPortraitContainer);
    }

    private void initRelatedContentLandscapeContainer() {
        this.mRelatedContentLandscapeContainer = (RelatedContentLandscapeContainer)this.mRootView.findViewById(R.id.RelatedContentLandscapeContainer);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
        this.mRelatedContentLandscapeContainer.measure(widthMeasureSpec, heightMeasureSpec);
        this.mSeekBarController.measure(widthMeasureSpec, heightMeasureSpec);
        this.mLandscapeRelatedContainerHideTranslateValue = this.mRelatedContentLandscapeContainer.getMeasuredHeight() + this.mSeekBarController.getMeasuredHeight();
        this.mRelatedContentLandscapeContainer.setTranslateDistance(this.mLandscapeRelatedContainerHideTranslateValue);
        View relatedContainerAnchor = this.mRootView.findViewById(R.id.LandscapeRelatedAnchorView);
        RelativeLayout.LayoutParams anchorParams = (RelativeLayout.LayoutParams)relatedContainerAnchor.getLayoutParams();
        anchorParams.height = this.mSeekBarController.getMeasuredHeight();
        relatedContainerAnchor.setLayoutParams((ViewGroup.LayoutParams)anchorParams);
        if (this.mContext.getResources().getConfiguration().orientation == 1) {
            this.setLandscapeRelatedContentContainerVisibility(false);
        } else {
            this.setLandscapeRelatedContentContainerVisibility(true);
        }
        this.mRelatedContentLandscapeContainer.setRelatedContentLandscapeContainerListener(new RelatedContentLandscapeContainer.RelatedContentLandscapeContainerListener(){

            @Override
            public void onInterceptTouchRequest() {
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        VideoPlayerController.this.animateControlsExit();
                    }
                }, 2500L);
            }

            @Override
            public void onRelatedPanelStateChanged(boolean isOpened) {
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mVideoPlayerListener.onRelatedPanelStateChanged(isOpened);
                }
            }
        });
    }

    private void initTopBar() {
        this.mVideoPlayerTopBar = (VideoPlayerTopBar)this.mRootView.findViewById(R.id.VideoPlayerTopBar);
        this.mVideoPlayerTopBar.setVideoPlayerTopBarListener(new VideoPlayerTopBar.VideoPlayerTopBarListener(){

            @Override
            public void onBackPressed() {
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mRootView.setBackgroundColor(Color.parseColor((String)"#000000"));
                    VideoPlayerController.this.mVideoPlayerContainerFrameLayout.setVisibility(4);
                    VideoPlayerController.this.mRootView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            VideoPlayerController.this.mVideoFragment.onDestroy();
                            VideoPlayerController.this.mVideoPlayerListener.onBackPressed();
                        }
                    }, 300L);
                }
            }

            @Override
            public void onLikeClicked() {
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mVideoPlayerListener.onLikeClicked();
                }
            }

            @Override
            public void onInfoClicked() {
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mVideoPlayerListener.onInfoClicked();
                }
            }
        });
    }

    private void setTopBarVisibility(boolean isVisible) {
        if (isVisible) {
            this.mVideoPlayerTopBar.setTranslationY(0.0f);
        } else {
            this.mVideoPlayerTopBar.setTranslationY(-1 * this.mVideoPlayerTopBar.getMeasuredHeight());
        }
    }

    private void setLandscapeRelatedContentContainerVisibility(boolean isVisible) {
        if (isVisible) {
            this.mRelatedContentLandscapeContainer.setTranslationY(0.0f);
        } else {
            this.mRelatedContentLandscapeContainer.setTranslationY(this.mLandscapeRelatedContainerHideTranslateValue);
        }
    }

    private void initRootView() {
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mRootView = layoutInflater.inflate(R.layout.video_player_controller, null, false);
        this.mRootView.setDuplicateParentStateEnabled(true);
    }

    public void initWindowParameters() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.gravity = 48;
        params.x = 0;
        params.y = 0;
        params.height = -1;
        params.width = -1;
        params.type = 2003;
        params.flags = 263976;
        params.format = -3;
        params.windowAnimations = R.style.VideoPlayerAnimation;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        windowManager.addView(this.mRootView, (ViewGroup.LayoutParams)params);
    }

    private void initSeekBarController() {
        this.mSeekBarController = (SeekBarController)this.mRootView.findViewById(R.id.SeekBarController);
        this.mSeekBarController.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser && VideoPlayerController.this.mVideoFragment != null) {
                    VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                    VideoPlayerController.this.animateControlsEnter();
                    int newProgress = (int)(VideoPlayerController.this.mVideoFragment.getVideoTotalTime() * (long)progress) / 100;
                    VideoPlayerController.this.mVideoFragment.seekVideo(newProgress);
                    VideoPlayerController.this.mSeekBarController.updateDuration(newProgress, VideoPlayerController.this.mVideoFragment.getVideoTotalTime());
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mSeekBarController.stopProgressUpdate();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                VideoPlayerController.this.mSeekBarController.updateDuration(VideoPlayerController.this.mVideoFragment.getVideoCurrentTime(), VideoPlayerController.this.mVideoFragment.getVideoTotalTime());
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.animateControlsExit();
                VideoPlayerController.this.mVideoFragment.playVideo();
            }
        });
        this.mSeekBarController.setSeekBarControllerListener(new SeekBarController.SeekBarControllerListener(){

            @Override
            public void onRequestProgressUpdate() {
                if (VideoPlayerController.this.mSeekBarController != null) {
                    VideoPlayerController.this.mSeekBarController.updateDuration(VideoPlayerController.this.mVideoFragment.getVideoCurrentTime(), VideoPlayerController.this.mVideoFragment.getVideoTotalTime());
                }
            }
        });
        if (this.mContext != null && this.mContext instanceof Activity) {
            this.mSeekBarController.setActivity((Activity)this.mContext);
        }
    }

    private void initPlayAndPauseButton() {
        this.mPlayAndPauseButton = (PlayAndPauseButton)this.mRootView.findViewById(R.id.PlayAndPauseButton);
        this.mPlayAndPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (VideoPlayerController.this.mVideoFragment != null) {
                            if (VideoPlayerController.this.mVideoFragment.getIsPlaying()) {
                                VideoPlayerController.this.mVideoFragment.pauseVideo();
                                VideoPlayerController.this.mIsUserPauseVideo = true;
                            } else {
                                VideoPlayerController.this.mIsUserPauseVideo = false;
                                if (VideoPlayerController.this.mPlayAndPauseButton.getPlayAndPauseStatus() == PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.ERROR) {
                                    VideoPlayerController.this.mVideoFragment.refreshVideo();
                                } else {
                                    VideoPlayerController.this.mVideoFragment.playVideo();
                                }
                            }
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
        this.mPlayAndPauseButton.setInterceptTouchEventListener(new PlayAndPauseButton.InterceptTouchEventListener(){

            @Override
            public void setIsCanInterceptTouchEvent(boolean isCanInterceptTouchEvent) {
                if (VideoPlayerController.this.mVideoControllerContainer != null) {
                    VideoPlayerController.this.mVideoControllerContainer.setIsInterceptTouchEvent(isCanInterceptTouchEvent);
                }
            }
        });
    }

    public boolean getIsUserPausedVideo() {
        return this.mIsUserPauseVideo;
    }

    private void initVideoContainerLayout() {
        this.mVideoControllerContainer = (InterceptableTouchEventRelativeLayout)this.mRootView.findViewById(R.id.VideoControllerContainer);
        this.mVideoContainerLayoutParams = (RelativeLayout.LayoutParams)this.mVideoControllerContainer.getLayoutParams();
        this.mVideoControllerContainer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean result = true;
                switch (event.getAction()) {
                    case 0: {
                        VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                        if (VideoPlayerController.this.mVideoControllerContainer.getIsInterceptTouchEvent()) {
                            VideoPlayerController.this.animateControlsEnter();
                            break;
                        }
                        VideoPlayerController.this.animateControlsExit();
                        break;
                    }
                    case 1: {
                        result = false;
                        if (VideoPlayerController.this.mPlayAndPauseButton.getPlayAndPauseStatus() != PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.PLAYING) break;
                        VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                        VideoPlayerController.this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                VideoPlayerController.this.animateControlsExit();
                            }
                        }, 2500L);
                    }
                }
                return result;
            }
        });
    }

    public void fixVideoLayout() {
        this.mRelatedContentPortraitContainer.refresh();
        this.mRelatedContentLandscapeContainer.refresh();
        if (this.mContext.getResources().getConfiguration().orientation == 1) {
            this.setLandscapeRelatedContentContainerVisibility(false);
            this.setTopBarVisibility(true);
            this.mVideoContainerLayoutParams = new RelativeLayout.LayoutParams(0, 0);
            this.mVideoContainerLayoutParams.width = ScreenUtils.getScreenSize(this.mContext, true);
            this.mVideoContainerLayoutParams.height = (int)((float)ScreenUtils.getScreenSize(this.mContext, false) * 0.315f);
            this.mVideoContainerLayoutParams.addRule(3, R.id.VideoPlayerTopBar);
            this.mVideoControllerContainer.setLayoutParams((ViewGroup.LayoutParams)this.mVideoContainerLayoutParams);
            if (this.mVideoPlayerContainerFrameLayout != null) {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mVideoPlayerContainerFrameLayout.getLayoutParams();
                params.addRule(3, R.id.AnchorView);
                params.width = ScreenUtils.getScreenSize(this.mContext, true);
                params.height = (int)((float)ScreenUtils.getScreenSize(this.mContext, false) * 0.315f);
                this.mVideoPlayerContainerFrameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else {
            if (this.mVideoFragment != null && !this.mVideoFragment.getIsPlaying()) {
                this.setTopBarVisibility(true);
                this.setLandscapeRelatedContentContainerVisibility(true);
            } else {
                this.setTopBarVisibility(false);
                this.setLandscapeRelatedContentContainerVisibility(false);
            }
            this.mVideoContainerLayoutParams = new RelativeLayout.LayoutParams(0, 0);
            this.mVideoContainerLayoutParams.width = ScreenUtils.getScreenSize(this.mContext, true);
            this.mVideoContainerLayoutParams.height = ScreenUtils.getScreenSize(this.mContext, false);
            this.mVideoControllerContainer.setLayoutParams((ViewGroup.LayoutParams)this.mVideoContainerLayoutParams);
            if (this.mVideoPlayerContainerFrameLayout != null) {
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
                this.mVideoPlayerContainerFrameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            if (this.mPlayAndPauseButton.getPlayAndPauseStatus() == PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.ERROR || this.mPlayAndPauseButton.getPlayAndPauseStatus() == PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.LOADING) {
                this.mRelatedContentLandscapeContainer.animateExit();
                this.mSeekBarController.animateExit();
            }
        }
    }

    public void closeView() {
        this.mSeekBarController.stopProgressUpdate();
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        windowManager.removeView(this.mRootView);
    }

    public void setKidAvatar(String kidAvatarURL) {
        this.mRelatedContentPortraitContainer.setKidAvatarURL(kidAvatarURL);
    }

    public void setVideoName(String videoName) {
        this.mRelatedContentPortraitContainer.setVideoName(videoName);
    }

    public void setRelatedContent(ArrayList<ContentItem> content) {
        this.mRelatedContentPortraitContainer.setContent(content);
        this.mRelatedContentLandscapeContainer.setContent(content);
    }

    public void setRelatedContentItemListener(AbstractContentPanel.IOnContentItemClickListener listener) {
        this.mRelatedContentPortraitContainer.setRelatedContentListener(listener);
        this.mRelatedContentLandscapeContainer.setRelatedContentListener(listener);
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener) {
        this.mVideoPlayerListener = videoPlayerListener;
    }

    public void setVideoFragment(VideoFragment videoFragment, FrameLayout videoPlayerContainerFrameLayout) {
        this.mVideoPlayerContainerFrameLayout = videoPlayerContainerFrameLayout;
        this.mVideoFragment = videoFragment;
        this.mVideoFragment.setVideoPlayerListener(new VideoPlayerListener(){

            @Override
            public void onBuffering(boolean isBuffering) {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onBuffering = " + Boolean.toString(isBuffering));
            }

            @Override
            public void reloadRelatedContent() {
            }

            @Override
            public void onPaused() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onPaused");
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.mPlayAndPauseButton.setStatus(PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.PAUSING);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mSeekBarController.stopProgressUpdate();
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mVideoPlayerListener.onPaused();
                }
            }

            @Override
            public void onPlaying() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onPlaying");
                VideoPlayerController.this.mVideoPlayerContainerFrameLayout.setVisibility(0);
                VideoPlayerController.this.mRootView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        VideoPlayerController.this.mRootView.setBackgroundColor(0);
                    }
                }, 400L);
                VideoPlayerController.this.mIsUserPauseVideo = false;
                if (VideoPlayerController.this.mContext != null && VideoPlayerController.this.mContext instanceof Activity) {
                    ScreenUtils.setScreenOrientation((Activity)VideoPlayerController.this.mContext, 4);
                    ScreenUtils.hideNavigationAndStatusBar(((Activity)VideoPlayerController.this.mContext).getWindow());
                }
                VideoPlayerController.this.mVideoPlayerListener.reloadRelatedContent();
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.mPlayAndPauseButton.setStatus(PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.PLAYING);
                VideoPlayerController.this.animateControlsExit();
                if (VideoPlayerController.this.mVideoPlayerListener != null) {
                    VideoPlayerController.this.mVideoPlayerListener.onPlaying();
                }
            }

            @Override
            public void onSeekTo(int newPosition) {
            }

            @Override
            public void onStopped() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onStopped");
            }

            @Override
            public void onError(String reason) {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>Can't load Video: " + reason);
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.mPlayAndPauseButton.setStatus(PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.ERROR);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mSeekBarController.stopProgressUpdate();
            }

            @Override
            public void onFinishedLoading() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onFinishedLoading");
                VideoPlayerController.this.mVideoFragment.playVideo();
                VideoPlayerController.this.mSeekBarController.updateDuration(VideoPlayerController.this.mVideoFragment.getVideoCurrentTime(), VideoPlayerController.this.mVideoFragment.getVideoTotalTime());
            }

            @Override
            public void onLoading() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onLoading");
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.mPlayAndPauseButton.setStatus(PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.LOADING);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mPlayAndPauseButton.animateLoading();
            }

            @Override
            public void onVideoEnded() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onVideoEnded");
                VideoPlayerController.this.mHandler.removeCallbacksAndMessages(null);
                VideoPlayerController.this.mPlayAndPauseButton.setStatus(PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.PAUSING);
                VideoPlayerController.this.animateControlsEnter();
                VideoPlayerController.this.mVideoPlayerListener.onVideoEnded();
            }

            @Override
            public void onVideoStarted() {
                SDKLogger.printErrorLog(VideoPlayerController.this.TAG, ">>>>onVideoStarted");
                VideoPlayerController.this.mVideoPlayerListener.onVideoStarted();
            }

            @Override
            public void onNext() {
            }

            @Override
            public void onPlaylistEnded() {
            }

            @Override
            public void onPrevious() {
            }

            @Override
            public void onBackPressed() {
            }

            @Override
            public void onLikeClicked() {
            }

            @Override
            public void onInfoClicked() {
            }

            @Override
            public void onRelatedPanelStateChanged(boolean isOpened) {
            }
        });
        this.mVideoFragment.setOnFullscreenListener(new YouTubePlayer.OnFullscreenListener(){

            public void onFullscreen(boolean isFullScreen) {
                VideoPlayerController.this.fixVideoLayout();
                VideoPlayerController.this.mSeekBarController.refreshRotateOnClickStatus();
            }
        });
        this.fixVideoLayout();
    }

    public void setNumberOfLikes(String numberOfLikes) {
        if (this.mVideoPlayerTopBar != null) {
            this.mVideoPlayerTopBar.setNumberOfLikesTextView(numberOfLikes);
        }
    }

    public void setLikeIndication(boolean isLiked) {
        if (this.mVideoPlayerTopBar != null) {
            this.mVideoPlayerTopBar.setLikeIndicationStatus(isLiked);
        }
    }

    private void animateControlsEnter() {
        this.mVideoPlayerTopBar.animateEnter();
        this.mPlayAndPauseButton.animateEnter();
        if (this.mPlayAndPauseButton.getPlayAndPauseStatus() != PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.ERROR && this.mPlayAndPauseButton.getPlayAndPauseStatus() != PlayAndPauseButton.PLAY_AND_PAUSE_STATUS.LOADING) {
            this.mRelatedContentLandscapeContainer.animateEnter();
            this.mSeekBarController.animateEnter();
        } else {
            this.mRelatedContentLandscapeContainer.animateExit();
            this.mSeekBarController.animateExit();
        }
        this.mVideoControllerContainer.setIsInterceptTouchEvent(false);
    }

    private void animateControlsExit() {
        this.mVideoPlayerTopBar.animateExit();
        this.mPlayAndPauseButton.animateExit();
        this.mSeekBarController.animateExit();
        this.mRelatedContentLandscapeContainer.animateExit();
        this.mVideoControllerContainer.setIsInterceptTouchEvent(true);
    }

    public void performClickIfNeeded(int x, int y) {
        this.mVideoPlayerTopBar.performClickIfNeeded(x, y);
    }
}

