/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.video_player.ui.custom_views;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.kidoz.sdk.api.R;
import com.kidoz.sdk.api.players.video_player.ui.custom_views.RotateVideoButton;
import com.kidoz.sdk.api.players.video_player.util.AnimationsUtils;
import com.kidoz.sdk.api.players.video_player.util.ScreenUtils;
import java.util.Formatter;
import java.util.Locale;

public class SeekBarController
extends RelativeLayout {
    private final String TAG = SeekBarController.class.getSimpleName();
    public static final int SEEK_BAR_MAX_PROGRESS_VALUE = 100;
    private final int UPDATE_PROGRESS = 1;
    private Activity mActivity;
    private View mRootView;
    private SeekBar mSeekBar;
    private RotateVideoButton mRotateVideoButton;
    private TextView mCurrentTimeTextView;
    private TextView mTotalTimeTextView;
    private StringBuilder mStringBuilder;
    private Formatter mFormatter;
    private SeekBarHandler mSeekBarHandler;
    private SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;
    private SeekBarControllerListener mSeekBarControllerListener;

    public SeekBarController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.mSeekBarHandler = new SeekBarHandler();
        this.mStringBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        this.mRootView = SeekBarController.inflate((Context)this.getContext(), (int)R.layout.seek_bar_layout, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.mRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(this.mRootView);
        this.initSeekBar();
        this.initTimeTextView();
        this.initRotateVideoButton();
    }

    private void initTimeTextView() {
        this.mCurrentTimeTextView = (TextView)this.mRootView.findViewById(R.id.CurrentTimeTextView);
        this.mTotalTimeTextView = (TextView)this.mRootView.findViewById(R.id.TotalTimeTextView);
        this.mCurrentTimeTextView.setText((CharSequence)this.convertTime(0L));
        this.mTotalTimeTextView.setText((CharSequence)this.convertTime(0L));
    }

    private void initRotateVideoButton() {
        this.mRotateVideoButton = (RotateVideoButton)this.mRootView.findViewById(R.id.RotateVideoButton);
        this.mRotateVideoButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AnimationsUtils.animateClick(view, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (SeekBarController.this.mActivity != null) {
                            if (SeekBarController.this.mRotateVideoButton.getIsOpenInFullScreen()) {
                                ScreenUtils.setScreenOrientation(SeekBarController.this.mActivity, 0);
                            } else {
                                ScreenUtils.setScreenOrientation(SeekBarController.this.mActivity, 1);
                            }
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void initSeekBar() {
        this.mSeekBar = (SeekBar)this.mRootView.findViewById(R.id.SeekBarController);
        this.mSeekBar.setMax(100);
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener onSeekBarChangeListener) {
        this.mOnSeekBarChangeListener = onSeekBarChangeListener;
        this.mSeekBar.setOnSeekBarChangeListener(this.mOnSeekBarChangeListener);
    }

    public void updateDuration(long currentTimeInMilliseconds, long totalTimeInMilliseconds) {
        if (totalTimeInMilliseconds > 0L) {
            float currentProgress = (float)currentTimeInMilliseconds / (float)totalTimeInMilliseconds * 100.0f;
            this.mSeekBar.setProgress((int)currentProgress);
        }
        this.mCurrentTimeTextView.setText((CharSequence)this.convertTime(currentTimeInMilliseconds));
        this.mTotalTimeTextView.setText((CharSequence)this.convertTime(totalTimeInMilliseconds));
    }

    public void animateEnter() {
        this.mSeekBarHandler.sendEmptyMessage(1);
        AnimationsUtils.animateRelatedContainerLandscapeSlideIn((View)this);
    }

    public void animateExit() {
        AnimationsUtils.animateRelatedContainerLandscapeSlideOut((View)this, this.getMeasuredHeight());
        this.mSeekBarHandler.removeCallbacksAndMessages(null);
    }

    public void stopProgressUpdate() {
        this.mSeekBarHandler.removeCallbacksAndMessages(null);
    }

    private String convertTime(long timeInMilliseconds) {
        String result = "00:00";
        if (timeInMilliseconds > 0L) {
            try {
                int totalSeconds = (int)timeInMilliseconds / 1000;
                int seconds = totalSeconds % 60;
                int minutes = totalSeconds / 60 % 60;
                int hours = totalSeconds / 3600;
                this.mStringBuilder.setLength(0);
                result = hours > 0 ? this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString() : this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void setSeekBarControllerListener(SeekBarControllerListener seekBarControllerListener) {
        this.mSeekBarControllerListener = seekBarControllerListener;
    }

    public void refreshRotateOnClickStatus() {
        this.mRotateVideoButton.refreshRotateOnClickStatus();
    }

    public static interface SeekBarControllerListener {
        public void onRequestProgressUpdate();
    }

    private class SeekBarHandler
    extends Handler {
        private SeekBarHandler() {
        }

        public void handleMessage(Message message) {
            if (message != null) {
                switch (message.what) {
                    case 1: {
                        if (SeekBarController.this.mSeekBarControllerListener != null) {
                            SeekBarController.this.mSeekBarControllerListener.onRequestProgressUpdate();
                        }
                        SeekBarController.this.mSeekBarHandler.sendEmptyMessageDelayed(1, 1000L);
                    }
                }
            }
        }
    }
}

